/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.tracing;

import io.opentelemetry.context.propagation.TextMapGetter;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public enum KafkaProducerRecordGetter implements TextMapGetter<ProducerRecord<?, ?>>
{
    INSTANCE;


    public Iterable<String> keys(ProducerRecord<?, ?> carrier) {
        return StreamSupport.stream(carrier.headers().spliterator(), false).map(Header::key).collect(Collectors.toList());
    }

    public String get(ProducerRecord<?, ?> carrier, String key) {
        if (carrier == null) {
            return null;
        }
        Header header = carrier.headers().lastHeader(key);
        if (header == null) {
            return null;
        }
        byte[] value = header.value();
        if (value == null) {
            return null;
        }
        return new String(value, StandardCharsets.UTF_8);
    }
}

