/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.tracing;

import io.debezium.tracing.KafkaProducerRecordGetter;
import io.debezium.tracing.OpenTelemetryInterceptorVersion;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumTracingProducerInterceptor<K, V>
implements ProducerInterceptor<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumTracingProducerInterceptor.class);
    private static final OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
    private static final Tracer tracer = openTelemetry.getTracer(DebeziumTracingProducerInterceptor.class.getName());
    private static final TextMapPropagator TEXT_MAP_PROPAGATOR = openTelemetry.getPropagators().getTextMapPropagator();
    private static final TextMapGetter<ProducerRecord<?, ?>> GETTER = KafkaProducerRecordGetter.INSTANCE;
    private Object interceptorInstance;
    private Method onSendMethod;

    public DebeziumTracingProducerInterceptor() {
        OpenTelemetryInterceptorVersion[] versions;
        for (OpenTelemetryInterceptorVersion version : versions = new OpenTelemetryInterceptorVersion[]{new OpenTelemetryInterceptorVersion("io.opentelemetry.instrumentation.kafkaclients.v2_6.TracingProducerInterceptor"), new OpenTelemetryInterceptorVersion("io.opentelemetry.instrumentation.kafkaclients.TracingProducerInterceptor")}) {
            this.interceptorInstance = version.createInstance();
            if (this.interceptorInstance == null) continue;
            this.onSendMethod = version.getMethod("onSend", ProducerRecord.class);
            if (this.onSendMethod != null) break;
        }
        if (this.onSendMethod == null) {
            LOGGER.error("Unable to instantiate any known version of the interceptor");
            throw new IllegalStateException("Unable to instantiate interceptor");
        }
    }

    /*
     * Loose catch block
     */
    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> producerRecord) {
        Context parentContext = TEXT_MAP_PROPAGATOR.extract(Context.current(), producerRecord, GETTER);
        Span interceptorSpan = tracer.spanBuilder("onSend").setSpanKind(SpanKind.INTERNAL).setParent(parentContext).startSpan();
        try {
            try (Scope ignored = interceptorSpan.makeCurrent();){
                ProducerRecord producerRecord2 = (ProducerRecord)this.onSendMethod.invoke(this.interceptorInstance, producerRecord);
                return producerRecord2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            interceptorSpan.end();
        }
    }

    public void onAcknowledgement(RecordMetadata recordMetadata, Exception e) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

