/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.spi;

import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngine;
import java.time.Duration;

@FunctionalInterface
public interface OffsetCommitPolicy {
    public static OffsetCommitPolicy always() {
        return new AlwaysCommitOffsetPolicy();
    }

    public static OffsetCommitPolicy periodic(Configuration config) {
        return new PeriodicCommitOffsetPolicy(config);
    }

    public boolean performCommit(long var1, Duration var3);

    default public OffsetCommitPolicy or(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) || other.performCommit(number, time);
    }

    default public OffsetCommitPolicy and(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) && other.performCommit(number, time);
    }

    public static class PeriodicCommitOffsetPolicy
    implements OffsetCommitPolicy {
        private final Duration minimumTime;

        public PeriodicCommitOffsetPolicy(Configuration config) {
            this.minimumTime = Duration.ofMillis(config.getLong(EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS));
        }

        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return timeSinceLastCommit.compareTo(this.minimumTime) >= 0;
        }
    }

    public static class AlwaysCommitOffsetPolicy
    implements OffsetCommitPolicy {
        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return true;
        }
    }
}

