/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.spatial.GeometryBytes;
import io.debezium.transforms.SmtManager;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryFormatTransformer<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryFormatTransformer.class);
    private static final Field GEOMETRY_FORMAT = Field.create("format").withDisplayName("Target Format").withEnum(GeometryFormat.class, GeometryFormat.WKB).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The target Geometry format to convert to. Options are 'wkb' and 'ewkb'");
    private SmtManager<R> smtManager;
    private GeometryFormat geometryFormat;

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, GEOMETRY_FORMAT);
        return config;
    }

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        this.smtManager.validate(config, Field.setOf(GEOMETRY_FORMAT));
        this.geometryFormat = GeometryFormat.parse(config.getString(GEOMETRY_FORMAT));
    }

    public void close() {
    }

    public R apply(R record) {
        Object object = record.value();
        if (object instanceof Struct) {
            Struct structValue = (Struct)object;
            this.processStruct(structValue, structValue.schema());
        }
        return record;
    }

    public String version() {
        return Module.version();
    }

    private Struct processStruct(Struct original, Schema schema) {
        schema.fields().forEach(field -> {
            Object value = original.get(field);
            original.put(field, this.processField(value, field.schema()));
        });
        return original;
    }

    private Object processField(Object value, Schema schema) {
        if (value == null) {
            return null;
        }
        if (schema.type() == Schema.Type.STRUCT) {
            if ("io.debezium.data.geometry.Geometry".equals(schema.name())) {
                return this.processGeometryStruct((Struct)value);
            }
            return this.processStruct((Struct)value, schema);
        }
        return value;
    }

    private Object processGeometryStruct(Struct value) {
        Integer srid = value.getInt32("srid");
        byte[] wkb = value.getBytes(GeometryFormat.WKB.getValue());
        GeometryBytes geometry = new GeometryBytes(wkb, srid);
        if (geometry.isExtended()) {
            this.geometryFormat = GeometryFormat.EWKB;
        }
        switch (this.geometryFormat.ordinal()) {
            case 0: {
                if (srid == null) {
                    String errorMessage = "Cannot convert to EWKB when SRID is null";
                    LOGGER.error(errorMessage);
                    throw new ConnectException(errorMessage);
                }
                return value.put("wkb", (Object)geometry.asExtendedWkb().getBytes());
            }
            case 1: {
                return value.put("wkb", (Object)geometry.asWkb().getBytes());
            }
        }
        return value;
    }

    public static enum GeometryFormat implements EnumeratedValue
    {
        WKB("wkb"),
        EWKB("ewkb");

        private final String value;

        private GeometryFormat(String value) {
            this.value = value;
        }

        public static GeometryFormat parse(String value) {
            if (value == null) {
                return WKB;
            }
            value = value.trim();
            for (GeometryFormat format : GeometryFormat.values()) {
                if (!format.getValue().equalsIgnoreCase(value)) continue;
                return format;
            }
            return WKB;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

