/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spatial;

import io.debezium.spatial.GeometryBytes;
import io.debezium.spatial.GeometryUtil;
import java.nio.ByteBuffer;

class GeometryFormatConverter {
    GeometryFormatConverter() {
    }

    public static GeometryBytes toExtendedWkb(GeometryBytes geometry) {
        if (geometry.isExtended()) {
            return geometry;
        }
        byte[] extendedWkb = GeometryFormatConverter.convertToExtendedWkb(geometry.getBytes(), geometry.getSrid());
        return new GeometryBytes(extendedWkb, geometry.getSrid());
    }

    public static GeometryBytes toWkb(GeometryBytes geometry) {
        if (!geometry.isExtended()) {
            return geometry;
        }
        byte[] wkb = GeometryFormatConverter.convertToWkb(geometry.getBytes());
        return new GeometryBytes(wkb, geometry.getSrid());
    }

    private static byte[] convertToExtendedWkb(byte[] wkb, Integer srid) {
        ByteBuffer buffer = ByteBuffer.wrap(wkb);
        byte byteOrder = buffer.get();
        buffer.order(GeometryUtil.getByteOrder(byteOrder));
        int wkbType = buffer.getInt();
        wkbType |= 0x20000000;
        ByteBuffer output = ByteBuffer.allocate(wkb.length + 4);
        output.put(byteOrder);
        output.order(buffer.order());
        output.putInt(wkbType);
        output.putInt(srid);
        output.put(buffer);
        return output.array();
    }

    private static byte[] convertToWkb(byte[] extendedWkb) {
        ByteBuffer buffer = ByteBuffer.wrap(extendedWkb);
        byte byteOrder = buffer.get();
        buffer.order(GeometryUtil.getByteOrder(byteOrder));
        int wkbType = buffer.getInt();
        wkbType &= 0xDFFFFFFF;
        buffer.getInt();
        ByteBuffer output = ByteBuffer.allocate(extendedWkb.length - 4);
        output.put(byteOrder);
        output.order(buffer.order());
        output.putInt(wkbType);
        output.put(buffer);
        return output.array();
    }
}

