/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.spatial.GeometryBytes;
import io.debezium.transforms.SmtManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;

public class SwapGeometryCoordinates<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Field SRIDS = Field.create("srids").withDisplayName("Geometry SRIDs that should be considered for coordinate swapping").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A comma-separated list of Geometry SRIDs that indicate which geometry fields should be included when swapping coordinates.");
    private SmtManager<R> smtManager;
    private List<Integer> sridList = List.of(Integer.valueOf(4326), Integer.valueOf(3857), Integer.valueOf(4269));

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, SRIDS);
        return config;
    }

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        this.smtManager.validate(config, Field.setOf(SRIDS));
        if (config.hasKey(SRIDS)) {
            this.sridList = config.getList(SRIDS).stream().map(Integer::valueOf).toList();
        }
    }

    public void close() {
    }

    public R apply(R record) {
        Object object = record.value();
        if (object instanceof Struct) {
            Struct structValue = (Struct)object;
            this.processStruct(structValue, structValue.schema());
        }
        return record;
    }

    public String version() {
        return Module.version();
    }

    private Struct processStruct(Struct original, Schema schema) {
        for (org.apache.kafka.connect.data.Field field : schema.fields()) {
            Object value = original.get(field);
            original.put(field, this.processField(value, field.schema()));
        }
        return original;
    }

    private Object processField(Object value, Schema schema) {
        if (value == null) {
            return null;
        }
        switch (schema.type()) {
            case STRUCT: {
                if ("io.debezium.data.geometry.Geometry".equals(schema.name())) {
                    return this.processGeometryStruct((Struct)value);
                }
                return this.processStruct((Struct)value, schema);
            }
            case ARRAY: {
                return ((List)value).stream().map(item -> this.processField(item, schema.valueSchema())).toList();
            }
            case MAP: {
                return ((Map)value).entrySet().stream().collect(Collectors.toMap(e -> this.processField(e.getKey(), schema.keySchema()), e -> this.processField(e.getValue(), schema.valueSchema())));
            }
        }
        return value;
    }

    private Object processGeometryStruct(Struct value) {
        Integer srid = value.getInt32("srid");
        if (srid == null) {
            return value;
        }
        byte[] wkb = value.getBytes("wkb");
        if (this.sridList.contains(srid)) {
            GeometryBytes geometry = new GeometryBytes(wkb, srid);
            value.put("wkb", (Object)geometry.swapCoordinatesNoCheck().getBytes());
        }
        return value;
    }
}

