/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.tracing;

import io.debezium.DebeziumException;
import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.transforms.SmtManager;
import io.debezium.transforms.tracing.TracingSpanUtil;
import io.opentelemetry.api.GlobalOpenTelemetry;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateTracingSpan<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivateTracingSpan.class);
    public static final String DEFAULT_TRACING_SPAN_CONTEXT_FIELD = "tracingspancontext";
    public static final String DEFAULT_TRACING_OPERATION_NAME = "debezium-read";
    private static final boolean OPEN_TELEMETRY_AVAILABLE = ActivateTracingSpan.resolveOpenTelemetryApiAvailable();
    public static final Field TRACING_SPAN_CONTEXT_FIELD = Field.create("tracing.span.context.field").withDisplayName("Serialized tracing span context field").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDefault("tracingspancontext").withDescription("The name of the field containing java.util.Properties representation of serialized span context. Defaults to 'tracingspancontext'");
    public static final Field TRACING_OPERATION_NAME = Field.create("tracing.operation.name").withDisplayName("Tracing operation name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDefault("debezium-read").withDescription("The operation name representing Debezium processing span. Default is 'debezium-read'");
    public static final Field TRACING_CONTEXT_FIELD_REQUIRED = Field.create("tracing.with.context.field.only").withDisplayName("Trace only events with context field present").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDefault(false).withDescription("Set to `true` when only events that have serialized context field should be traced.");
    private String spanContextField;
    private String operationName;
    private boolean requireContextField;
    private SmtManager<R> smtManager;

    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        Field.Set configFields = Field.setOf(TRACING_SPAN_CONTEXT_FIELD, TRACING_OPERATION_NAME);
        if (!config.validateAndRecord(configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.spanContextField = config.getString(TRACING_SPAN_CONTEXT_FIELD);
        this.operationName = config.getString(TRACING_OPERATION_NAME);
        this.requireContextField = config.getBoolean(TRACING_CONTEXT_FIELD_REQUIRED);
        this.smtManager = new SmtManager(config);
    }

    public void setRequireContextField(boolean requireContextField) {
        this.requireContextField = requireContextField;
    }

    public R apply(R connectRecord) {
        if (connectRecord.value() == null || !this.smtManager.isValidEnvelope(connectRecord)) {
            return connectRecord;
        }
        Struct envelope = (Struct)connectRecord.value();
        Struct after = envelope.schema().field("after") != null ? envelope.getStruct("after") : null;
        Struct source = envelope.schema().field("source") != null ? envelope.getStruct("source") : null;
        String propagatedSpanContext = null;
        if (after != null && after.schema().field(this.spanContextField) != null) {
            propagatedSpanContext = after.getString(this.spanContextField);
        }
        if (propagatedSpanContext == null && this.requireContextField) {
            return connectRecord;
        }
        try {
            return TracingSpanUtil.traceRecord(connectRecord, envelope, source, propagatedSpanContext, this.operationName);
        }
        catch (NoClassDefFoundError e) {
            throw new DebeziumException("Failed to record tracing information, tracing libraries not available", (Throwable)e);
        }
    }

    public void close() {
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, TRACING_SPAN_CONTEXT_FIELD, TRACING_OPERATION_NAME, TRACING_CONTEXT_FIELD_REQUIRED);
        return config;
    }

    public String version() {
        return Module.version();
    }

    public static boolean isOpenTelemetryAvailable() {
        return OPEN_TELEMETRY_AVAILABLE;
    }

    private static boolean resolveOpenTelemetryApiAvailable() {
        try {
            GlobalOpenTelemetry.get();
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }
}

