/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;

public interface SchemaResource {
    public static final String SCHEMA_ENDPOINT = "/schema";
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public String getSchemaFilePath();

    @GET
    @Path(value="/schema")
    default public JsonNode getConnectorSchema() {
        try {
            return (JsonNode)MAPPER.readValue(this.getClass().getResourceAsStream(this.getSchemaFilePath()), JsonNode.class);
        }
        catch (IOException e) {
            throw new DebeziumException("Unable to open \"" + this.getSchemaFilePath().substring(this.getSchemaFilePath().lastIndexOf(File.separator) + 1) + "\" schema file.", (Throwable)e);
        }
    }
}

