/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.config.Field;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceRecord;

public interface Heartbeat
extends AutoCloseable {
    public static final String HEARTBEAT_INTERVAL_PROPERTY_NAME = "heartbeat.interval.ms";
    public static final Field HEARTBEAT_INTERVAL = Field.create("heartbeat.interval.ms").withDisplayName("Connector heartbeat interval (milli-seconds)").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.ADVANCED_HEARTBEAT, 0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.").withDefault(0).withValidation(Field::isNonNegativeInteger);
    public static final Field HEARTBEAT_TOPICS_PREFIX = Field.create("heartbeat.topics.prefix").withDisplayName("A prefix used for naming of heartbeat topics").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.ADVANCED_HEARTBEAT, 1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.").withDefault("__debezium-heartbeat");
    public static final Heartbeat DEFAULT_NOOP_HEARTBEAT = () -> false;

    @Deprecated
    default public void heartbeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
    }

    @Deprecated
    default public void heartbeat(Map<String, ?> partition, OffsetProducer offsetProducer, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
    }

    @Deprecated
    default public void forcedBeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
    }

    default public void emit(Map<String, ?> partition, OffsetContext offset) throws InterruptedException {
    }

    public boolean isEnabled();

    @Override
    default public void close() {
    }

    public static interface ScheduledHeartbeat
    extends Heartbeat {
        public static final ScheduledHeartbeat NOOP_HEARTBEAT = () -> false;

        default public void emitWithDelay(Map<String, ?> partition, OffsetContext offset) throws InterruptedException {
        }

        default public boolean expired() {
            return false;
        }

        default public void reset() {
        }
    }

    @FunctionalInterface
    public static interface OffsetProducer {
        public Map<String, ?> offset();
    }
}

