/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public class CdcSourceTaskContext {
    private final String connectorType;
    private final String connectorLogicalName;
    private final String connectorPluginName;
    private final String taskId;
    private final Map<String, String> customMetricTags;
    private final Clock clock;
    private final CommonConnectorConfig config;
    private final Supplier<Collection<? extends DataCollectionId>> collectionsSupplier;

    public CdcSourceTaskContext(CommonConnectorConfig config, String taskId, Map<String, String> customMetricTags, Supplier<Collection<? extends DataCollectionId>> collectionsSupplier) {
        this.connectorType = config.getContextName();
        this.connectorLogicalName = config.getLogicalName();
        this.connectorPluginName = config.getConnectorName();
        this.taskId = taskId;
        this.customMetricTags = customMetricTags;
        this.collectionsSupplier = collectionsSupplier != null ? collectionsSupplier : Collections::emptyList;
        this.config = config;
        this.clock = Clock.system();
    }

    public CdcSourceTaskContext(CommonConnectorConfig config, Map<String, String> customMetricTags, Supplier<Collection<? extends DataCollectionId>> collectionsSupplier) {
        this(config, "0", customMetricTags, collectionsSupplier);
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector(this.connectorType, this.connectorLogicalName, contextName);
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName, Partition partition) {
        return LoggingContext.forConnector(this.connectorType, this.connectorLogicalName, this.taskId, contextName, partition);
    }

    public void temporaryLoggingContext(CommonConnectorConfig connectorConfig, String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector("MySQL", connectorConfig.getLogicalName(), contextName, operation);
    }

    public Clock getClock() {
        return this.clock;
    }

    public String[] capturedDataCollections() {
        return (String[])this.collectionsSupplier.get().stream().map(DataCollectionId::toString).toArray(String[]::new);
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getConnectorLogicalName() {
        return this.connectorLogicalName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getConnectorPluginName() {
        return this.connectorPluginName;
    }

    public Map<String, String> getCustomMetricTags() {
        return this.customMetricTags;
    }

    public CommonConnectorConfig getConfig() {
        return this.config;
    }
}

