/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.facets;

import io.openlineage.client.OpenLineage;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class DebeziumConfigFacet
implements OpenLineage.RunFacet {
    public static final String FACET_KEY_NAME = "debezium_config";
    private static final String CONFIG_LINE_FORMAT = "%s=%s";
    private final URI producer;
    private final List<String> configs;

    public DebeziumConfigFacet(URI producer, Map<String, String> configurations) {
        this.producer = producer;
        this.configs = configurations.entrySet().stream().map(e -> String.format(CONFIG_LINE_FORMAT, e.getKey(), e.getValue())).toList();
    }

    public URI get_producer() {
        return this.producer;
    }

    public URI get_schemaURL() {
        return URI.create("https://github.com/debezium/debezium/tree/main/debezium-core/src/main/java/io/debezium/openlineage/facets/spec/DebeziumRunFacet.json");
    }

    public List<String> getConfigs() {
        return this.configs;
    }

    public Map<String, Object> getAdditionalProperties() {
        return Map.of();
    }
}

