/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import io.debezium.schema.FieldNameSelector;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.util.SchemaUtil;

public class JsonSchemaData {
    private final EventRouterConfigDefinition.JsonPayloadNullFieldBehavior jsonPayloadNullFieldBehavior;
    private final FieldNameSelector.FieldNamer<String> fieldNamer;

    public JsonSchemaData() {
        this.jsonPayloadNullFieldBehavior = EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.IGNORE;
        this.fieldNamer = FieldNameSelector.defaultNonRelationalSelector(SchemaNameAdjuster.NO_OP);
    }

    public JsonSchemaData(EventRouterConfigDefinition.JsonPayloadNullFieldBehavior jsonPayloadNullFieldBehavior, FieldNameSelector.FieldNamer<String> fieldNamer) {
        this.jsonPayloadNullFieldBehavior = jsonPayloadNullFieldBehavior;
        this.fieldNamer = fieldNamer;
    }

    public Schema toConnectSchema(String key, JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case NUMBER: {
                if (node.isInt()) {
                    return Schema.OPTIONAL_INT32_SCHEMA;
                }
                if (node.isLong()) {
                    return Schema.OPTIONAL_INT64_SCHEMA;
                }
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)node;
                return arrayNode.isEmpty() ? null : SchemaBuilder.array((Schema)this.toConnectSchemaWithCycles(key, arrayNode)).optional().build();
            }
            case OBJECT: {
                SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(key).optional();
                node.fields().forEachRemaining(entry -> {
                    String fieldName = this.fieldNamer.fieldNameFor((String)entry.getKey());
                    String fieldKey = (String)(Strings.isNullOrBlank(key) ? "" : key + ".") + fieldName;
                    Schema fieldSchema = this.toConnectSchema(fieldKey, (JsonNode)entry.getValue());
                    if (fieldSchema != null && !this.hasField(schemaBuilder, fieldName)) {
                        schemaBuilder.field(fieldName, fieldSchema);
                    }
                });
                return schemaBuilder.build();
            }
            case NULL: {
                if (this.jsonPayloadNullFieldBehavior.equals(EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.OPTIONAL_BYTES)) {
                    return Schema.OPTIONAL_BYTES_SCHEMA;
                }
                return null;
            }
        }
        return null;
    }

    private Schema toConnectSchemaWithCycles(String key, ArrayNode array) throws ConnectException {
        Schema schema = null;
        JsonNode sample = this.getFirstArrayElement(array);
        if (sample.isObject()) {
            HashSet<Schema> elementSchemas = new HashSet<Schema>();
            Iterator elements = array.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                if (!element.isObject()) continue;
                elementSchemas.add(this.toConnectSchema(key, element));
            }
            for (Schema element : elementSchemas) {
                schema = this.mergeSchema(schema, element);
            }
        } else {
            schema = this.toConnectSchema(null, sample);
            if (schema == null) {
                throw new ConnectException(String.format("Array '%s' has unrecognized member schema.", array.asText()));
            }
        }
        return schema;
    }

    private Schema mergeSchema(Schema left, Schema right) {
        if (left == null) {
            return right;
        }
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        left.fields().forEach(field -> fields.put(field.name(), (Field)field));
        right.fields().forEach(field -> {
            Field oldField = (Field)fields.get(field.name());
            if (oldField == null) {
                fields.put(field.name(), (Field)field);
            } else if (!Objects.equals(oldField.schema(), field.schema()) && oldField.schema().type() == Schema.Type.BYTES && field.schema().type() != Schema.Type.BYTES) {
                fields.put(field.name(), (Field)field);
            }
        });
        SchemaBuilder newBuilder = SchemaUtil.copySchemaBasics((Schema)left);
        fields.forEach((k, v) -> newBuilder.field(k, v.schema()));
        return newBuilder.build();
    }

    private JsonNode getFirstArrayElement(ArrayNode array) throws ConnectException {
        NullNode refNode = NullNode.getInstance();
        Schema refSchema = null;
        Iterator elements = array.elements();
        while (elements.hasNext()) {
            Schema elementSchema;
            JsonNode element = (JsonNode)elements.next();
            if (element.isNull()) continue;
            if (refNode.isNull()) {
                refNode = element;
            }
            if (element.getNodeType() != refNode.getNodeType()) {
                throw new ConnectException(String.format("Field is not a homogenous array (%s x %s).", refNode.asText(), element.getNodeType().toString()));
            }
            if (refNode.getNodeType() != JsonNodeType.NUMBER) continue;
            if (refSchema == null) {
                refSchema = this.toConnectSchema(null, (JsonNode)refNode);
            }
            if (refSchema == (elementSchema = this.toConnectSchema(null, element))) continue;
            throw new ConnectException(String.format("Field is not a homogenous array (%s x %s), different number types (%s x %s)", refNode.asText(), element.asText(), refSchema, elementSchema));
        }
        return refNode;
    }

    private boolean hasField(SchemaBuilder builder, String fieldName) {
        return builder.field(fieldName) != null;
    }

    public Object toConnectData(JsonNode document, Schema schema) {
        if (document == null) {
            return null;
        }
        return this.jsonNodeToStructInternal(document, schema);
    }

    private Struct jsonNodeToStructInternal(JsonNode document, Schema schema) {
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            if (!document.has(field.name())) continue;
            struct.put(field.name(), this.getStructFieldValue(document.path(field.name()), field.schema()));
        }
        return struct;
    }

    private Object getStructFieldValue(JsonNode node, Schema schema) {
        switch (node.getNodeType()) {
            case STRING: {
                return node.asText();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NUMBER: {
                if (node.isFloat()) {
                    return Float.valueOf(node.floatValue());
                }
                if (node.isDouble()) {
                    return node.asDouble();
                }
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                return node.decimalValue();
            }
            case ARRAY: {
                return this.getArrayAsList((ArrayNode)node, schema);
            }
            case OBJECT: {
                return this.jsonNodeToStructInternal(node, schema);
            }
        }
        return null;
    }

    private List<Object> getArrayAsList(ArrayNode array, Schema schema) {
        ArrayList<Object> arrayObjects = new ArrayList<Object>(array.size());
        Iterator elements = array.elements();
        while (elements.hasNext()) {
            arrayObjects.add(this.getStructFieldValue((JsonNode)elements.next(), schema.valueSchema()));
        }
        return arrayObjects;
    }
}

