/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.extractnewstate;

import io.debezium.DebeziumException;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.extractnewstate.AbstractExtractRecordStrategy;
import io.debezium.util.Loggings;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LegacyDeleteHandlingStrategy<R extends ConnectRecord<R>>
extends AbstractExtractRecordStrategy<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyDeleteHandlingStrategy.class);
    private final ExtractNewRecordStateConfigDefinition.DeleteHandling deleteHandling;
    private final boolean dropTombstones;

    public LegacyDeleteHandlingStrategy(ExtractNewRecordStateConfigDefinition.DeleteHandling deleteHandling, boolean dropTombstones, boolean replaceNullWithDefault) {
        super(replaceNullWithDefault);
        this.deleteHandling = deleteHandling;
        this.dropTombstones = dropTombstones;
    }

    @Override
    public R handleTombstoneRecord(R record) {
        if (this.dropTombstones) {
            LOGGER.trace("Tombstone {} arrived and requested to be dropped", Loggings.maybeRedactSensitiveData(record.key()));
            return null;
        }
        return record;
    }

    @Override
    public R handleDeleteRecord(R record) {
        switch (this.deleteHandling) {
            case DROP: {
                LOGGER.trace("Delete message {} requested to be dropped", Loggings.maybeRedactSensitiveData(record.key()));
                return null;
            }
            case NONE: {
                return (R)this.afterDelegate.apply(record);
            }
            case REWRITE: {
                LOGGER.trace("Delete message {} requested to be rewritten", Loggings.maybeRedactSensitiveData(record.key()));
                ConnectRecord oldRecord = this.beforeDelegate.apply(record);
                if (oldRecord.value() instanceof Struct) {
                    return (R)this.removedDelegate.apply(oldRecord);
                }
                return (R)oldRecord;
            }
        }
        throw new DebeziumException("Unknown delete handling mode: " + String.valueOf(this.deleteHandling));
    }

    @Override
    public R handleRecord(R record) {
        ConnectRecord newRecord = this.afterDelegate.apply(record);
        if (this.deleteHandling == ExtractNewRecordStateConfigDefinition.DeleteHandling.REWRITE) {
            LOGGER.trace("Insert/update message {} requested to be rewritten", Loggings.maybeRedactSensitiveData(record.key()));
            if (newRecord.value() instanceof Struct) {
                return (R)this.updatedDelegate.apply(newRecord);
            }
        }
        return (R)newRecord;
    }

    @Override
    public boolean isRewriteMode() {
        return this.deleteHandling == ExtractNewRecordStateConfigDefinition.DeleteHandling.REWRITE;
    }
}

