/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.transforms.ConnectRecordUtil;
import io.debezium.transforms.SmtManager;
import io.debezium.util.BoundedConcurrentHashMap;
import io.debezium.util.Loggings;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderToValue<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderToValue.class);
    public static final String FIELDS_CONF = "fields";
    public static final String HEADERS_CONF = "headers";
    public static final String OPERATION_CONF = "operation";
    private static final String MOVE_OPERATION = "move";
    private static final String COPY_OPERATION = "copy";
    private static final int CACHE_SIZE = 64;
    public static final Field HEADERS_FIELD = Field.create("headers").withDisplayName("Header names list").withType(ConfigDef.Type.LIST).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::notContainSpaceInAnyElement, Field::notContainEmptyElements).withDescription("Header names in the record whose values are to be copied or moved to record value.").required();
    public static final Field FIELDS_FIELD = Field.create("fields").withDisplayName("Field names list").withType(ConfigDef.Type.LIST).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::notContainSpaceInAnyElement, Field::notContainEmptyElements).withDescription("Field names, in the same order as the header names listed in the headers configuration property. Supports Struct nesting using dot notation.").required();
    public static final Field OPERATION_FIELD = Field.create("operation").withDisplayName("Operation: mover or copy").withType(ConfigDef.Type.STRING).withEnum(Operation.class).withImportance(ConfigDef.Importance.HIGH).withDescription("Either <code>move</code> if the fields are to be moved to the value (removed from the headers), or <code>copy</code> if the fields are to be copied to the value (retained in the headers).").required();
    private List<String> fields;
    private List<String> headers;
    private Operation operation;
    private final BoundedConcurrentHashMap<Schema, Schema> schemaUpdateCache = new BoundedConcurrentHashMap(64);
    private final BoundedConcurrentHashMap<Headers, Headers> headersUpdateCache = new BoundedConcurrentHashMap(64);

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, HEADERS_FIELD, FIELDS_FIELD, OPERATION_FIELD);
        return config;
    }

    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        SmtManager smtManager = new SmtManager(config);
        smtManager.validate(config, Field.setOf(FIELDS_FIELD, HEADERS_FIELD, OPERATION_FIELD));
        this.fields = config.getList(FIELDS_FIELD);
        this.headers = config.getList(HEADERS_FIELD);
        this.validateConfiguration();
        this.operation = Operation.fromName(config.getString(OPERATION_FIELD));
    }

    private void validateConfiguration() {
        if (this.headers.size() != this.fields.size()) {
            throw new ConfigException(String.format("'%s' config must have the same number of elements as '%s' config.", FIELDS_FIELD, HEADERS_FIELD));
        }
    }

    public R apply(R record) {
        if (record.value() == null) {
            Loggings.logTraceAndTraceRecord(LOGGER, record.key(), "Tombstone record arrived and will be skipped", new Object[0]);
            return record;
        }
        Struct value = Requirements.requireStruct((Object)record.value(), (String)"Header field insertion");
        Loggings.logTraceAndTraceRecord(LOGGER, value, "Processing record", new Object[0]);
        LinkedList<ConnectRecordUtil.NewEntry> newEntries = new LinkedList<ConnectRecordUtil.NewEntry>();
        for (Header header : record.headers()) {
            int headerIndex = this.headers.indexOf(header.key());
            if (headerIndex <= -1) continue;
            newEntries.add(new ConnectRecordUtil.NewEntry(this.fields.get(headerIndex), header.schema(), header.value()));
        }
        if (newEntries.isEmpty()) {
            return record;
        }
        Schema updatedSchema = this.schemaUpdateCache.computeIfAbsent(value.schema(), valueSchema -> ConnectRecordUtil.makeNewSchema(valueSchema, newEntries));
        LOGGER.trace("Updated schema fields: {}", (Object)updatedSchema.fields());
        Struct updatedValue = ConnectRecordUtil.makeUpdatedValue(value, newEntries, updatedSchema);
        Loggings.logTraceAndTraceRecord(LOGGER, updatedValue, "Updated value", new Object[0]);
        Headers updatedHeaders = record.headers();
        if (Operation.MOVE.equals((Object)this.operation)) {
            updatedHeaders = this.headersUpdateCache.computeIfAbsent(record.headers(), this::removeHeaders);
        }
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, (Object)updatedValue, record.timestamp(), (Iterable)updatedHeaders);
    }

    private Headers removeHeaders(Headers originalHeaders) {
        Headers updatedHeaders = originalHeaders.duplicate();
        this.headers.forEach(arg_0 -> ((Headers)updatedHeaders).remove(arg_0));
        return updatedHeaders;
    }

    private String headersToString(Map<?, ?> map) {
        return map.keySet().stream().map(key -> String.valueOf(key) + "=" + String.valueOf(map.get(key))).collect(Collectors.joining(", ", "{", "}"));
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }

    static enum Operation {
        MOVE("move"),
        COPY("copy");

        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        static Operation fromName(String name) {
            switch (name) {
                case "move": {
                    return MOVE;
                }
                case "copy": {
                    return COPY;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.name;
        }
    }
}

