/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.data.Bits;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.Xml;
import io.debezium.jdbc.ResultReceiver;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.jdbc.ValueConversionCallback;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.time.Date;
import io.debezium.time.IsoDate;
import io.debezium.time.IsoTime;
import io.debezium.time.IsoTimestamp;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTime;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Time;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.HexConverter;
import io.debezium.util.NumberConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjuster;
import java.util.Base64;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class JdbcValueConverters
implements ValueConverterProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ZoneOffset defaultOffset;
    protected final String fallbackTimestampWithTimeZone;
    private final String fallbackTimeWithTimeZone;
    protected final TemporalPrecisionMode temporalPrecisionMode;
    protected final DecimalMode decimalMode;
    protected final TemporalAdjuster adjuster;
    protected final BigIntUnsignedMode bigIntUnsignedMode;
    protected final CommonConnectorConfig.BinaryHandlingMode binaryMode;

    public JdbcValueConverters() {
        this(null, TemporalPrecisionMode.ADAPTIVE, ZoneOffset.UTC, null, null, null);
    }

    public JdbcValueConverters(DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, ZoneOffset defaultOffset, TemporalAdjuster adjuster, BigIntUnsignedMode bigIntUnsignedMode, CommonConnectorConfig.BinaryHandlingMode binaryMode) {
        this.defaultOffset = defaultOffset != null ? defaultOffset : ZoneOffset.UTC;
        this.temporalPrecisionMode = temporalPrecisionMode;
        this.decimalMode = decimalMode != null ? decimalMode : DecimalMode.PRECISE;
        this.adjuster = adjuster;
        this.bigIntUnsignedMode = bigIntUnsignedMode != null ? bigIntUnsignedMode : BigIntUnsignedMode.PRECISE;
        this.binaryMode = binaryMode != null ? binaryMode : CommonConnectorConfig.BinaryHandlingMode.BYTES;
        this.fallbackTimestampWithTimeZone = ZonedTimestamp.toIsoString(OffsetDateTime.of(LocalDate.ofEpochDay(0L), LocalTime.MIDNIGHT, defaultOffset), defaultOffset, adjuster, null);
        this.fallbackTimeWithTimeZone = ZonedTime.toIsoString(OffsetTime.of(LocalTime.MIDNIGHT, defaultOffset), (ZoneId)defaultOffset, adjuster);
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        switch (column.jdbcType()) {
            case 0: {
                this.logger.warn("Unexpected JDBC type: NULL");
                return null;
            }
            case -7: {
                if (column.length() > 1) {
                    return Bits.builder(column.length());
                }
            }
            case 16: {
                return SchemaBuilder.bool();
            }
            case -2: 
            case 2004: {
                return this.binaryMode.getSchema();
            }
            case -4: 
            case -3: {
                return this.binaryMode.getSchema();
            }
            case -6: {
                return SchemaBuilder.int8();
            }
            case 5: {
                return SchemaBuilder.int16();
            }
            case 4: {
                return SchemaBuilder.int32();
            }
            case -5: {
                return SchemaBuilder.int64();
            }
            case 7: {
                return SchemaBuilder.float32();
            }
            case 6: 
            case 8: {
                return SchemaBuilder.float64();
            }
            case 2: 
            case 3: {
                return SpecialValueDecimal.builder(this.decimalMode, column.length(), column.scale().get());
            }
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 2011: {
                return SchemaBuilder.string();
            }
            case -1: 
            case 12: 
            case 70: 
            case 2005: {
                return SchemaBuilder.string();
            }
            case 2009: {
                return Xml.builder();
            }
            case 91: {
                return this.temporalPrecisionMode.getDateBuilder();
            }
            case 92: {
                return this.temporalPrecisionMode.getTimeBuilder(this.getTimePrecision(column));
            }
            case 93: {
                return this.temporalPrecisionMode.getTimestampBuilder(this.getTimePrecision(column));
            }
            case 2013: {
                return ZonedTime.builder();
            }
            case 2014: {
                return ZonedTimestamp.builder();
            }
            case -8: {
                return SchemaBuilder.bytes();
            }
        }
        return null;
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case 0: {
                return data -> null;
            }
            case -7: {
                return this.convertBits(column, fieldDefn);
            }
            case 16: {
                return data -> this.convertBoolean(column, fieldDefn, data);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data, this.binaryMode);
            }
            case -6: {
                return data -> this.convertTinyInt(column, fieldDefn, data);
            }
            case 5: {
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case 4: {
                return data -> this.convertInteger(column, fieldDefn, data);
            }
            case -5: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 6: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 8: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 7: {
                return data -> this.convertReal(column, fieldDefn, data);
            }
            case 2: {
                return data -> this.convertNumeric(column, fieldDefn, data);
            }
            case 3: {
                return data -> this.convertDecimal(column, fieldDefn, data);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 91: {
                return data -> this.convertDate(column, fieldDefn, data);
            }
            case 92: {
                return data -> this.convertTime(column, fieldDefn, data);
            }
            case 93: {
                return data -> this.convertTimestamp(column, fieldDefn, data);
            }
            case 2013: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 2014: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -8: {
                return data -> this.convertRowId(column, fieldDefn, data);
            }
        }
        return null;
    }

    protected ValueConverter convertBits(Column column, Field fieldDefn) {
        if (column.length() > 1) {
            int numBits = column.length();
            int numBytes = numBits / 8 + (numBits % 8 == 0 ? 0 : 1);
            return data -> this.convertBits(column, fieldDefn, data, numBytes);
        }
        return data -> this.convertBit(column, fieldDefn, data);
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, this.fallbackTimestampWithTimeZone, r -> {
            try {
                r.deliver(ZonedTimestamp.toIsoString(data, this.defaultOffset, this.adjuster, column.length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, this.fallbackTimeWithTimeZone, r -> {
            try {
                r.deliver(ZonedTime.toIsoString(data, (ZoneId)this.defaultOffset, this.adjuster));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertDate(Column column, Field fieldDefn, Object data) {
        switch (this.temporalPrecisionMode) {
            case ISOSTRING: {
                return this.convertDateToUtcIsoString(column, fieldDefn, data);
            }
            case ADAPTIVE_TIME_MICROSECONDS: 
            case NANOSECONDS: 
            case MICROSECONDS: 
            case ADAPTIVE: {
                return this.convertDateToEpochDays(column, fieldDefn, data);
            }
        }
        return this.convertDateToEpochDaysAsDate(column, fieldDefn, data);
    }

    protected Object convertTime(Column column, Field fieldDefn, Object data) {
        switch (this.temporalPrecisionMode) {
            case ISOSTRING: {
                return this.convertTimeToUtcIsoString(column, fieldDefn, data);
            }
            case MICROSECONDS: {
                return this.convertTimeToMicrosPastMidnight(column, fieldDefn, data);
            }
            case NANOSECONDS: {
                return this.convertTimeToNanosPastMidnight(column, fieldDefn, data);
            }
            case ADAPTIVE_TIME_MICROSECONDS: {
                return this.convertTimeToMicrosPastMidnight(column, fieldDefn, data);
            }
            case ADAPTIVE: {
                if (this.getTimePrecision(column) <= 3) {
                    return this.convertTimeToMillisPastMidnight(column, fieldDefn, data);
                }
                if (this.getTimePrecision(column) <= 6) {
                    return this.convertTimeToMicrosPastMidnight(column, fieldDefn, data);
                }
                return this.convertTimeToNanosPastMidnight(column, fieldDefn, data);
            }
        }
        return this.convertTimeToMillisPastMidnightAsDate(column, fieldDefn, data);
    }

    protected Object convertTimestamp(Column column, Field fieldDefn, Object data) {
        switch (this.temporalPrecisionMode) {
            case ADAPTIVE_TIME_MICROSECONDS: 
            case ADAPTIVE: {
                if (this.getTimePrecision(column) <= 3) {
                    return this.convertTimestampToEpochMillis(column, fieldDefn, data);
                }
                if (this.getTimePrecision(column) <= 6) {
                    return this.convertTimestampToEpochMicros(column, fieldDefn, data);
                }
                return this.convertTimestampToEpochNanos(column, fieldDefn, data);
            }
            case ISOSTRING: {
                return this.convertTimestampToUtcIsoString(column, fieldDefn, data);
            }
            case MICROSECONDS: {
                return this.convertTimestampToEpochMicros(column, fieldDefn, data);
            }
            case NANOSECONDS: {
                return this.convertTimestampToEpochNanos(column, fieldDefn, data);
            }
        }
        return this.convertTimestampToEpochMillisAsDate(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            try {
                r.deliver(Timestamp.toEpochMillis(data, this.adjuster));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            try {
                r.deliver(MicroTimestamp.toEpochMicros(data, this.adjuster));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            try {
                r.deliver(NanoTimestamp.toEpochNanos(data, this.adjuster));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, new java.util.Date(0L), r -> {
            try {
                r.deliver(new java.util.Date(Timestamp.toEpochMillis(data, this.adjuster)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimeToMillisPastMidnight(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0, r -> {
            try {
                r.deliver(Time.toMilliOfDay(data, this.supportsLargeTimeValues()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimeToMicrosPastMidnight(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            try {
                r.deliver(MicroTime.toMicroOfDay(data, this.supportsLargeTimeValues()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimeToNanosPastMidnight(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            try {
                r.deliver(NanoTime.toNanoOfDay(data, this.supportsLargeTimeValues()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertTimeToMillisPastMidnightAsDate(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, new java.util.Date(0L), r -> {
            try {
                r.deliver(new java.util.Date(Time.toMilliOfDay(data, this.supportsLargeTimeValues())));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    protected Object convertDateToEpochDays(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0, r -> {
            try {
                r.deliver(Date.toEpochDay(data, this.adjuster));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            }
        });
    }

    protected Object convertDateToUtcIsoString(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "1970-01-01Z", r -> {
            try {
                r.deliver(IsoDate.toIsoString(data, this.adjuster));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            }
        });
    }

    protected Object convertTimeToUtcIsoString(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "00:00:00Z", r -> {
            try {
                r.deliver(IsoTime.toIsoString(data, this.supportsLargeTimeValues()));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unexpected JDBC Time value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            }
        });
    }

    protected Object convertTimestampToUtcIsoString(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "1970-01-01T00:00:00Z", r -> {
            try {
                r.deliver(IsoTimestamp.toIsoString(data, this.adjuster));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unexpected JDBC Timestamp value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            }
        });
    }

    protected Object convertDateToEpochDaysAsDate(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, new java.util.Date(0L), r -> {
            try {
                int epochDay = Date.toEpochDay(data, this.adjuster);
                long epochMillis = TimeUnit.DAYS.toMillis(epochDay);
                r.deliver(new java.util.Date(epochMillis));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            }
        });
    }

    protected Object convertBinary(Column column, Field fieldDefn, Object data, CommonConnectorConfig.BinaryHandlingMode mode) {
        switch (mode) {
            case BASE64: {
                return this.convertBinaryToBase64(column, fieldDefn, data);
            }
            case BASE64_URL_SAFE: {
                return this.convertBinaryToBase64UrlSafe(column, fieldDefn, data);
            }
            case HEX: {
                return this.convertBinaryToHex(column, fieldDefn, data);
            }
        }
        return this.convertBinaryToBytes(column, fieldDefn, data);
    }

    protected Object convertBinaryToBytes(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.BYTE_ZERO, r -> {
            if (data instanceof String) {
                r.deliver(this.toByteBuffer((String)data));
            } else if (data instanceof char[]) {
                r.deliver(this.toByteBuffer((char[])data));
            } else if (data instanceof byte[]) {
                r.deliver(this.toByteBuffer(column, (byte[])data));
            } else {
                r.deliver(this.unexpectedBinary(data, fieldDefn));
            }
        });
    }

    protected Object convertBinaryToBase64(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            Base64.Encoder base64Encoder = Base64.getEncoder();
            if (data instanceof String) {
                r.deliver(new String(base64Encoder.encode(((String)data).getBytes(StandardCharsets.UTF_8))));
            } else if (data instanceof char[]) {
                r.deliver(new String(base64Encoder.encode(this.toByteArray((char[])data)), StandardCharsets.UTF_8));
            } else if (data instanceof byte[]) {
                r.deliver(new String(base64Encoder.encode(this.normalizeBinaryData(column, (byte[])data)), StandardCharsets.UTF_8));
            } else {
                r.deliver(this.unexpectedBinary(data, fieldDefn));
            }
        });
    }

    protected Object convertBinaryToBase64UrlSafe(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            Base64.Encoder base64UrlSafeEncoder = Base64.getUrlEncoder();
            if (data instanceof String) {
                r.deliver(new String(base64UrlSafeEncoder.encode(((String)data).getBytes(StandardCharsets.UTF_8))));
            } else if (data instanceof char[]) {
                r.deliver(new String(base64UrlSafeEncoder.encode(this.toByteArray((char[])data)), StandardCharsets.UTF_8));
            } else if (data instanceof byte[]) {
                r.deliver(new String(base64UrlSafeEncoder.encode(this.normalizeBinaryData(column, (byte[])data)), StandardCharsets.UTF_8));
            } else {
                r.deliver(this.unexpectedBinary(data, fieldDefn));
            }
        });
    }

    protected Object convertBinaryToHex(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof String) {
                r.deliver(HexConverter.convertToHexString(((String)data).getBytes(StandardCharsets.UTF_8)));
            } else if (data instanceof char[]) {
                r.deliver(HexConverter.convertToHexString(this.toByteArray((char[])data)));
            } else if (data instanceof byte[]) {
                r.deliver(HexConverter.convertToHexString(this.normalizeBinaryData(column, (byte[])data)));
            } else {
                r.deliver(this.unexpectedBinary(data, fieldDefn));
            }
        });
    }

    protected ByteBuffer toByteBuffer(Column column, byte[] data) {
        return ByteBuffer.wrap(this.normalizeBinaryData(column, data));
    }

    protected byte[] normalizeBinaryData(Column column, byte[] data) {
        return data;
    }

    protected byte[] unexpectedBinary(Object value, Field fieldDefn) {
        this.logger.warn("Unexpected JDBC BINARY value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertSmallInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.SHORT_FALSE, r -> {
            if (data instanceof Short) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver(value.shortValue());
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getShort((Boolean)data));
            } else if (data instanceof String) {
                r.deliver(Short.valueOf((String)data));
            }
        });
    }

    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0, r -> {
            if (data instanceof Integer) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver(value.intValue());
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getInteger((Boolean)data));
            } else if (data instanceof String) {
                r.deliver(Integer.valueOf((String)data));
            }
        });
    }

    protected Object convertBigInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0L, r -> {
            if (data instanceof Long) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver(value.longValue());
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getLong((Boolean)data));
            } else if (data instanceof String) {
                r.deliver(Long.valueOf((String)data));
            }
        });
    }

    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        return this.convertDouble(column, fieldDefn, data);
    }

    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, 0.0, r -> {
            if (data instanceof Double) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver(value.doubleValue());
            } else if (data instanceof SpecialValueDecimal) {
                r.deliver(((SpecialValueDecimal)data).toDouble());
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getDouble((Boolean)data));
            }
        });
    }

    protected Object convertReal(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, Float.valueOf(0.0f), r -> {
            if (data instanceof Float) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver(Float.valueOf(value.floatValue()));
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getFloat((Boolean)data));
            }
        });
    }

    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        return this.convertDecimal(column, fieldDefn, data);
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data instanceof SpecialValueDecimal) {
            return SpecialValueDecimal.fromLogical((SpecialValueDecimal)data, this.decimalMode, column.name());
        }
        Object decimal = this.toBigDecimal(column, fieldDefn, data);
        if (decimal instanceof BigDecimal) {
            return SpecialValueDecimal.fromLogical(new SpecialValueDecimal((BigDecimal)decimal), this.decimalMode, column.name());
        }
        return decimal;
    }

    protected Object toBigDecimal(Column column, Field fieldDefn, Object data) {
        BigDecimal fallback = this.withScaleAdjustedIfNeeded(column, BigDecimal.ZERO);
        return this.convertValue(column, fieldDefn, data, fallback, r -> {
            if (data instanceof BigDecimal) {
                r.deliver(data);
            } else if (data instanceof BigInteger) {
                r.deliver(new BigDecimal((BigInteger)data));
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getBigDecimal((Boolean)data));
            } else if (data instanceof Short) {
                r.deliver(new BigDecimal(((Short)data).intValue()));
            } else if (data instanceof Integer) {
                r.deliver(new BigDecimal((Integer)data));
            } else if (data instanceof Long) {
                r.deliver(BigDecimal.valueOf((Long)data));
            } else if (data instanceof Float) {
                r.deliver(BigDecimal.valueOf(((Float)data).doubleValue()));
            } else if (data instanceof Double) {
                r.deliver(BigDecimal.valueOf((Double)data));
            } else if (data instanceof String) {
                r.deliver(new BigDecimal((String)data));
            }
        });
    }

    protected BigDecimal withScaleAdjustedIfNeeded(Column column, BigDecimal data) {
        if (column.scale().isPresent() && column.scale().get() > data.scale()) {
            data = data.setScale(column.scale().get());
        }
        return data;
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof SQLXML) {
                try {
                    r.deliver(((SQLXML)data).getString());
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error processing data from " + column.jdbcType() + " and column " + String.valueOf(column) + ": class=" + String.valueOf(data.getClass()), e);
                }
            } else {
                r.deliver(data.toString());
            }
        });
    }

    protected Object convertRowId(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.BYTE_BUFFER_ZERO, r -> {
            if (data instanceof RowId) {
                RowId row = (RowId)data;
                r.deliver(ByteBuffer.wrap(row.getBytes()));
            }
        });
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, false, r -> {
            if (data instanceof Boolean) {
                r.deliver(data);
            } else if (data instanceof Short) {
                r.deliver(((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE);
            } else if (data instanceof Integer) {
                r.deliver((Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE);
            } else if (data instanceof Long) {
                r.deliver(((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE);
            } else if (data instanceof BitSet) {
                BitSet value = (BitSet)data;
                r.deliver(value.get(0));
            }
        });
    }

    protected Object convertBits(Column column, Field fieldDefn, Object data, int numBytes) {
        return this.convertValue(column, fieldDefn, data, new byte[0], r -> {
            if (data instanceof Boolean) {
                Boolean value = (Boolean)data;
                r.deliver(new byte[]{value != false ? (byte)1 : (byte)0});
            } else if (data instanceof byte[]) {
                byte[] bytes = (byte[])data;
                if (bytes.length == 1) {
                    r.deliver(bytes);
                }
                if (this.byteOrderOfBitType() == ByteOrder.BIG_ENDIAN) {
                    int i = 0;
                    for (int j = bytes.length - 1; j > i; ++i, --j) {
                        byte tmp = bytes[j];
                        bytes[j] = bytes[i];
                        bytes[i] = tmp;
                    }
                }
                r.deliver(this.padLittleEndian(numBytes, bytes));
            } else if (data instanceof BitSet) {
                byte[] bytes = ((BitSet)data).toByteArray();
                r.deliver(this.padLittleEndian(numBytes, bytes));
            }
        });
    }

    protected byte[] padLittleEndian(int numBytes, byte[] data) {
        if (data.length < numBytes) {
            byte[] padded = new byte[numBytes];
            System.arraycopy(data, 0, padded, 0, data.length);
            return padded;
        }
        return data;
    }

    protected ByteOrder byteOrderOfBitType() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, false, r -> {
            if (data instanceof Boolean) {
                r.deliver(data);
            } else if (data instanceof Short) {
                r.deliver(((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE);
            } else if (data instanceof Integer) {
                r.deliver((Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE);
            } else if (data instanceof Long) {
                r.deliver(((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE);
            }
        });
    }

    protected Object handleUnknownData(Column column, Field fieldDefn, Object data) {
        String clazzName;
        Class<?> dataClass = data.getClass();
        String string = clazzName = dataClass.isArray() ? dataClass.getSimpleName() : dataClass.getName();
        if (column.isOptional() || fieldDefn.schema().isOptional()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected value for JDBC type {} and column {}: class={}", new Object[]{column.jdbcType(), column, clazzName});
            }
            return null;
        }
        throw new IllegalArgumentException("Unexpected value for JDBC type " + column.jdbcType() + " and column " + String.valueOf(column) + ": class=" + clazzName);
    }

    protected int getTimePrecision(Column column) {
        return column.length();
    }

    protected Object convertValue(Column column, Field fieldDefn, Object data, Object fallback, ValueConversionCallback callback) {
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            Object schemaDefault = fieldDefn.schema().defaultValue();
            return schemaDefault != null ? schemaDefault : fallback;
        }
        this.logger.trace("Value from data object: *** {} ***", data);
        ResultReceiver r = ResultReceiver.create();
        callback.convert(r);
        this.logger.trace("Callback is: {}", (Object)callback);
        this.logger.trace("Value from ResultReceiver: {}", (Object)r);
        return r.hasReceived() ? r.get() : this.handleUnknownData(column, fieldDefn, data);
    }

    private boolean supportsLargeTimeValues() {
        return this.temporalPrecisionMode == TemporalPrecisionMode.ADAPTIVE || this.temporalPrecisionMode == TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS || this.temporalPrecisionMode == TemporalPrecisionMode.MICROSECONDS || this.temporalPrecisionMode == TemporalPrecisionMode.NANOSECONDS;
    }

    private byte[] toByteArray(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        return byteBuffer.array();
    }

    private ByteBuffer toByteBuffer(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        return Charset.forName("UTF-8").encode(charBuffer);
    }

    private ByteBuffer toByteBuffer(String string) {
        return ByteBuffer.wrap(string.getBytes(StandardCharsets.UTF_8));
    }

    public static enum DecimalMode {
        PRECISE,
        DOUBLE,
        STRING;

    }

    public static enum BigIntUnsignedMode {
        PRECISE,
        LONG;

    }
}

