/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.Immutable;
import io.debezium.document.Array;
import io.debezium.document.Value;
import java.util.Objects;

@Immutable
final class BasicEntry
implements Array.Entry,
Comparable<Array.Entry> {
    private final int index;
    private final Value value;

    BasicEntry(int index, Value value) {
        this.index = index;
        this.value = value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return "@" + this.index + "=" + String.valueOf(this.value);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Array.Entry) {
            Array.Entry that = (Array.Entry)obj;
            return this.getIndex() == that.getIndex() && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int compareTo(Array.Entry that) {
        if (this == that) {
            return 0;
        }
        if (this.getIndex() != that.getIndex()) {
            return this.getIndex() - that.getIndex();
        }
        return Value.compareTo(this.getValue(), that.getValue());
    }
}

