/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SourceInfoStructMaker;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractSourceInfoStructMaker<T extends AbstractSourceInfo>
implements SourceInfoStructMaker<T> {
    public static final Schema SNAPSHOT_RECORD_SCHEMA = io.debezium.data.Enum.builder(String.join((CharSequence)",", Arrays.stream(SnapshotRecord.values()).map(Enum::name).map(String::toLowerCase).toList())).defaultValue((Object)SnapshotRecord.FALSE.name().toLowerCase()).optional().build();
    private String version;
    private String connector;
    private String serverName;

    @Override
    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.version = Objects.requireNonNull(version);
        this.serverName = connectorConfig.getLogicalName();
    }

    protected SchemaBuilder commonSchemaBuilder() {
        return SchemaBuilder.struct().field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA).field("sequence", Schema.OPTIONAL_STRING_SCHEMA).field("ts_us", Schema.OPTIONAL_INT64_SCHEMA).field("ts_ns", Schema.OPTIONAL_INT64_SCHEMA);
    }

    protected Struct commonStruct(T sourceInfo) {
        SnapshotRecord snapshot;
        Instant timestamp = ((AbstractSourceInfo)sourceInfo).timestamp() == null ? Instant.now() : ((AbstractSourceInfo)sourceInfo).timestamp();
        String database = ((AbstractSourceInfo)sourceInfo).database() == null ? "" : ((AbstractSourceInfo)sourceInfo).database();
        Struct ret = new Struct(this.schema()).put("version", (Object)this.version).put("connector", (Object)this.connector).put("name", (Object)this.serverName).put("ts_ms", (Object)timestamp.toEpochMilli()).put("db", (Object)database).put("ts_us", (Object)(timestamp.getEpochSecond() * 1000000L + (long)(timestamp.getNano() / 1000))).put("ts_ns", (Object)(timestamp.getEpochSecond() * 1000000000L + (long)timestamp.getNano()));
        String sequence = ((AbstractSourceInfo)sourceInfo).sequence();
        if (sequence != null) {
            ret.put("sequence", (Object)sequence);
        }
        if ((snapshot = ((AbstractSourceInfo)sourceInfo).snapshot()) != null) {
            snapshot.toSource(ret);
        }
        return ret;
    }
}

