/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.extractnewstate;

import io.debezium.transforms.ConnectRecordUtil;
import io.debezium.transforms.extractnewstate.ExtractRecordStrategy;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.InsertField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtractRecordStrategy<R extends ConnectRecord<R>>
implements ExtractRecordStrategy<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExtractRecordStrategy.class);
    protected ExtractField<R> afterDelegate;
    protected ExtractField<R> beforeDelegate;
    protected InsertField<R> removedDelegate;
    protected InsertField<R> updatedDelegate;
    protected ExtractField<R> updateDescriptionDelegate;

    public AbstractExtractRecordStrategy() {
        this.init();
    }

    private void init() {
        this.afterDelegate = ConnectRecordUtil.extractAfterDelegate();
        this.beforeDelegate = ConnectRecordUtil.extractBeforeDelegate();
        this.removedDelegate = ConnectRecordUtil.insertStaticValueDelegate("__deleted", "true");
        this.updatedDelegate = ConnectRecordUtil.insertStaticValueDelegate("__deleted", "false");
        this.updateDescriptionDelegate = ConnectRecordUtil.extractUpdateDescriptionDelegate();
    }

    @Override
    public R handleTruncateRecord(R record) {
        LOGGER.trace("Truncate event arrived and requested to be dropped");
        return null;
    }

    @Override
    public ExtractField<R> afterDelegate() {
        return this.afterDelegate;
    }

    @Override
    public ExtractField<R> beforeDelegate() {
        return this.beforeDelegate;
    }

    @Override
    public ExtractField<R> updateDescriptionDelegate() {
        return this.updateDescriptionDelegate;
    }

    @Override
    public void close() {
        this.beforeDelegate.close();
        this.afterDelegate.close();
        this.removedDelegate.close();
        this.updatedDelegate.close();
        this.updateDescriptionDelegate.close();
    }
}

