/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.spi;

import io.debezium.pipeline.spi.OffsetContext;

public class SnapshotResult<O extends OffsetContext> {
    private final SnapshotResultStatus status;
    private final O offset;

    private SnapshotResult(SnapshotResultStatus status, O offset) {
        this.status = status;
        this.offset = offset;
    }

    public static <O extends OffsetContext> SnapshotResult<O> completed(O offset) {
        return new SnapshotResult<O>(SnapshotResultStatus.COMPLETED, offset);
    }

    public static <O extends OffsetContext> SnapshotResult<O> aborted() {
        return new SnapshotResult<Object>(SnapshotResultStatus.ABORTED, null);
    }

    public static <O extends OffsetContext> SnapshotResult<O> skipped(O offset) {
        return new SnapshotResult<O>(SnapshotResultStatus.SKIPPED, offset);
    }

    public boolean isCompletedOrSkipped() {
        return this.status == SnapshotResultStatus.SKIPPED || this.status == SnapshotResultStatus.COMPLETED;
    }

    public boolean isCompleted() {
        return this.status == SnapshotResultStatus.COMPLETED;
    }

    public SnapshotResultStatus getStatus() {
        return this.status;
    }

    public O getOffset() {
        return this.offset;
    }

    public String toString() {
        return "SnapshotResult [status=" + this.status + ", offset=" + this.offset + "]";
    }

    public static enum SnapshotResultStatus {
        STARTED,
        COMPLETED,
        ABORTED,
        SKIPPED;

    }
}

