/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.AbstractChunkQueryBuilder;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.spi.schema.DataCollectionId;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.OptionalLong;

public class RowValueConstructorChunkQueryBuilder<T extends DataCollectionId>
extends AbstractChunkQueryBuilder<T> {
    public RowValueConstructorChunkQueryBuilder(RelationalDatabaseConnectorConfig config, JdbcConnection jdbcConnection) {
        super(config, jdbcConnection);
    }

    private boolean fallbackToSuper(List<Column> pkColumns) {
        return pkColumns.stream().anyMatch(Column::isOptional);
    }

    private void rowValueComparison(List<Column> pkColumns, String operator, StringBuilder sql) {
        boolean isLastIterationForI;
        int i;
        if (pkColumns.size() > 1) {
            sql.append("ROW(");
        }
        for (i = 0; i < pkColumns.size(); ++i) {
            isLastIterationForI = i == pkColumns.size() - 1;
            String pkColumnName = this.jdbcConnection.quotedColumnIdString(pkColumns.get(i).name());
            sql.append(pkColumnName);
            if (isLastIterationForI) continue;
            sql.append(", ");
        }
        if (pkColumns.size() > 1) {
            sql.append(')');
        }
        sql.append(' ');
        sql.append(operator);
        sql.append(' ');
        if (pkColumns.size() > 1) {
            sql.append("ROW(");
        }
        for (i = 0; i < pkColumns.size(); ++i) {
            isLastIterationForI = i == pkColumns.size() - 1;
            sql.append("?");
            if (isLastIterationForI) continue;
            sql.append(", ");
        }
        if (pkColumns.size() > 1) {
            sql.append(")");
        }
    }

    @Override
    protected void addLowerBound(IncrementalSnapshotContext<T> context, Table table, Object[] boundaryKey, StringBuilder sql) {
        List<Column> pkColumns = this.getQueryColumns(context, table);
        if (this.fallbackToSuper(pkColumns)) {
            super.addLowerBound(context, table, boundaryKey, sql);
            return;
        }
        this.rowValueComparison(pkColumns, ">", sql);
    }

    @Override
    protected void addUpperBound(IncrementalSnapshotContext<T> context, Table table, Object[] boundaryKey, StringBuilder sql) {
        List<Column> pkColumns = this.getQueryColumns(context, table);
        if (this.fallbackToSuper(pkColumns)) {
            super.addUpperBound(context, table, boundaryKey, sql);
            return;
        }
        this.rowValueComparison(pkColumns, "<=", sql);
    }

    @Override
    public PreparedStatement readTableChunkStatement(IncrementalSnapshotContext<T> context, Table table, String sql) throws SQLException {
        List<Column> queryColumns = this.getQueryColumns(context, table);
        if (this.fallbackToSuper(queryColumns)) {
            return super.readTableChunkStatement(context, table, sql);
        }
        PreparedStatement statement = this.jdbcConnection.readTablePreparedStatement(this.connectorConfig, sql, OptionalLong.empty());
        if (context.isNonInitialChunk()) {
            int i;
            Object[] maximumKey = context.maximumKey().get();
            Object[] chunkEndPosition = context.chunkEndPosititon();
            int pos = 0;
            for (i = 0; i < chunkEndPosition.length; ++i) {
                this.jdbcConnection.setQueryColumnValue(statement, queryColumns.get(i), ++pos, chunkEndPosition[i]);
            }
            for (i = 0; i < maximumKey.length; ++i) {
                this.jdbcConnection.setQueryColumnValue(statement, queryColumns.get(i), ++pos, maximumKey[i]);
            }
        }
        return statement;
    }
}

