/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.ChunkQueryBuilder;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.relational.Column;
import io.debezium.relational.Key;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.spi.schema.DataCollectionId;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public abstract class AbstractChunkQueryBuilder<T extends DataCollectionId>
implements ChunkQueryBuilder<T> {
    protected final RelationalDatabaseConnectorConfig connectorConfig;
    protected final JdbcConnection jdbcConnection;
    protected Tables.ColumnNameFilter columnFilter;

    public AbstractChunkQueryBuilder(RelationalDatabaseConnectorConfig config, JdbcConnection jdbcConnection) {
        this.connectorConfig = config;
        this.jdbcConnection = jdbcConnection;
        this.columnFilter = config.getColumnFilter();
    }

    @Override
    public String buildChunkQuery(IncrementalSnapshotContext<T> context, Table table, Optional<String> additionalCondition) {
        return this.buildChunkQuery(context, table, this.connectorConfig.getIncrementalSnapshotChunkSize(), additionalCondition);
    }

    @Override
    public String buildChunkQuery(IncrementalSnapshotContext<T> context, Table table, int limit, Optional<String> additionalCondition) {
        String condition = null;
        if (context.isNonInitialChunk()) {
            Object[] maximumKey = context.maximumKey().get();
            Object[] chunkEndPosition = context.chunkEndPosititon();
            StringBuilder sql = new StringBuilder();
            this.addLowerBound(context, table, chunkEndPosition, sql);
            sql.append(" AND ");
            this.addUpperBound(context, table, maximumKey, sql);
            condition = sql.toString();
        }
        List<Column> queryColumns = this.getQueryColumns(context, table);
        if (this.jdbcConnection.nullsSortLast().isEmpty() && queryColumns.stream().anyMatch(Column::isOptional)) {
            throw new UnsupportedOperationException("The sort order of NULL values in the incremental snapshot key is unknown.");
        }
        String orderBy = queryColumns.stream().map(c -> this.jdbcConnection.quotedColumnIdString(c.name())).collect(Collectors.joining(", "));
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), limit, this.buildProjection(table), Optional.ofNullable(condition), additionalCondition, orderBy);
    }

    protected String buildProjection(Table table) {
        String projection = "*";
        if (this.connectorConfig.isColumnsFiltered()) {
            TableId tableId = table.id();
            projection = table.columns().stream().filter(column -> this.columnFilter.matches(tableId.catalog(), tableId.schema(), tableId.table(), column.name())).map(column -> this.jdbcConnection.quotedColumnIdString(column.name())).collect(Collectors.joining(", "));
        }
        return projection;
    }

    protected void addLowerBound(IncrementalSnapshotContext<T> context, Table table, Object[] boundaryKey, StringBuilder sql) {
        List<Column> pkColumns = this.getQueryColumns(context, table);
        Optional<Boolean> nullsSortLast = this.jdbcConnection.nullsSortLast();
        if (pkColumns.size() > 1) {
            sql.append('(');
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            boolean isLastIterationForI = i == pkColumns.size() - 1;
            sql.append('(');
            for (int j = 0; j < i + 1; ++j) {
                boolean isLastIterationForJ = i == j;
                String pkColumnName = this.jdbcConnection.quotedColumnIdString(pkColumns.get(j).name());
                if (pkColumns.get(j).isRequired()) {
                    sql.append(pkColumnName);
                    sql.append(isLastIterationForJ ? " > ?" : " = ?");
                } else if (boundaryKey[j] != null) {
                    if (isLastIterationForJ) {
                        sql.append('(');
                        sql.append(pkColumnName);
                        sql.append(" > ?");
                        if (nullsSortLast.get().booleanValue()) {
                            sql.append(" OR ");
                            sql.append(pkColumnName);
                            sql.append(" IS NULL)");
                        } else {
                            sql.append(" AND ");
                            sql.append(pkColumnName);
                            sql.append(" IS NOT NULL)");
                        }
                    } else {
                        sql.append(pkColumnName);
                        sql.append(" = ?");
                    }
                } else if (isLastIterationForJ) {
                    if (nullsSortLast.get().booleanValue()) {
                        sql.append("1 = 0");
                    } else {
                        sql.append(pkColumnName);
                        sql.append(" IS NOT NULL");
                    }
                } else {
                    sql.append(pkColumnName);
                    sql.append(" IS NULL");
                }
                if (isLastIterationForJ) continue;
                sql.append(" AND ");
            }
            sql.append(")");
            if (isLastIterationForI) continue;
            sql.append(" OR ");
        }
        if (pkColumns.size() > 1) {
            sql.append(')');
        }
    }

    protected void addUpperBound(IncrementalSnapshotContext<T> context, Table table, Object[] boundaryKey, StringBuilder sql) {
        sql.append("NOT ");
        this.addLowerBound(context, table, boundaryKey, sql);
    }

    @Override
    public PreparedStatement readTableChunkStatement(IncrementalSnapshotContext<T> context, Table table, String sql) throws SQLException {
        PreparedStatement statement = this.jdbcConnection.readTablePreparedStatement(this.connectorConfig, sql, OptionalLong.empty());
        if (context.isNonInitialChunk()) {
            int j;
            int i;
            Object[] maximumKey = context.maximumKey().get();
            Object[] chunkEndPosition = context.chunkEndPosititon();
            int pos = 0;
            List<Column> queryColumns = this.getQueryColumns(context, table);
            for (i = 0; i < chunkEndPosition.length; ++i) {
                for (j = 0; j < i + 1; ++j) {
                    if (chunkEndPosition[j] == null) continue;
                    this.jdbcConnection.setQueryColumnValue(statement, queryColumns.get(j), ++pos, chunkEndPosition[j]);
                }
            }
            for (i = 0; i < maximumKey.length; ++i) {
                for (j = 0; j < i + 1; ++j) {
                    if (maximumKey[j] == null) continue;
                    this.jdbcConnection.setQueryColumnValue(statement, queryColumns.get(j), ++pos, maximumKey[j]);
                }
            }
        }
        return statement;
    }

    @Override
    public String buildMaxPrimaryKeyQuery(IncrementalSnapshotContext<T> context, Table table, Optional<String> additionalCondition) {
        String orderBy = this.getQueryColumns(context, table).stream().map(c -> this.jdbcConnection.quotedColumnIdString(c.name())).collect(Collectors.joining(" DESC, ")) + " DESC";
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), 1, this.buildProjection(table), Optional.empty(), additionalCondition, orderBy);
    }

    private Key.KeyMapper getKeyMapper() {
        return this.connectorConfig.getKeyMapper() == null ? table -> table.primaryKeyColumns() : this.connectorConfig.getKeyMapper();
    }

    @Override
    public List<Column> getQueryColumns(IncrementalSnapshotContext<T> context, Table table) {
        Optional<String> surrogateKey;
        if (context != null && context.currentDataCollectionId() != null && (surrogateKey = context.currentDataCollectionId().getSurrogateKey()).isPresent()) {
            return Collections.singletonList(table.columnWithName(surrogateKey.get()));
        }
        return this.getKeyMapper().getKeyKolumns(table);
    }
}

