/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.JmxUtils;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.connect.errors.ConnectException;

@ThreadSafe
public abstract class Metrics {
    private final ObjectName name;
    private volatile boolean registered = false;

    protected Metrics(CdcSourceTaskContext taskContext, String contextName) {
        this.name = this.metricName(taskContext.getConnectorType(), taskContext.getConnectorName(), contextName, taskContext.getCustomMetricTags());
    }

    protected Metrics(CdcSourceTaskContext taskContext, Map<String, String> tags) {
        tags.putAll(taskContext.getCustomMetricTags());
        this.name = this.metricName(taskContext.getConnectorType(), tags);
    }

    protected Metrics(CommonConnectorConfig connectorConfig, String contextName, boolean multiPartitionMode) {
        String connectorType = connectorConfig.getContextName();
        String connectorName = connectorConfig.getLogicalName();
        if (multiPartitionMode) {
            Map<String, String> tags = Collect.linkMapOf("server", connectorName, "task", connectorConfig.getTaskId(), "context", contextName);
            tags.putAll(connectorConfig.getCustomMetricTags());
            this.name = this.metricName(connectorType, tags);
        } else {
            this.name = this.metricName(connectorType, connectorName, contextName, connectorConfig.getCustomMetricTags());
        }
    }

    public synchronized void register() {
        JmxUtils.registerMXBean(this.name, this);
        this.registered = true;
    }

    public synchronized void unregister() {
        if (this.name != null && this.registered) {
            JmxUtils.unregisterMXBean(this.name);
            this.registered = false;
        }
    }

    protected ObjectName metricName(String connectorType, String connectorName, String contextName, Map<String, String> customTags) {
        Map<String, String> tags = Collect.linkMapOf("context", contextName, "server", connectorName);
        tags.putAll(customTags);
        return this.metricName(connectorType, tags);
    }

    protected ObjectName metricName(String connectorType, Map<String, String> tags) {
        String metricName = "debezium." + connectorType.toLowerCase() + ":type=connector-metrics," + tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + Sanitizer.jmxSanitize((String)((String)e.getValue()))).collect(Collectors.joining(","));
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e2) {
            throw new ConnectException("Invalid metric name '" + metricName + "'");
        }
    }
}

