/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import java.time.Duration;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface DelayStrategy {
    default public boolean sleepWhen(BooleanSupplier criteria) {
        return this.sleepWhen(criteria.getAsBoolean());
    }

    public boolean sleepWhen(boolean var1);

    public static DelayStrategy none() {
        return criteria -> false;
    }

    public static DelayStrategy constant(Duration delay) {
        long delayInMilliseconds = delay.toMillis();
        return criteria -> {
            if (!criteria) {
                return false;
            }
            try {
                Thread.sleep(delayInMilliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        };
    }

    public static DelayStrategy linear(Duration delay) {
        final long delayInMilliseconds = delay.toMillis();
        if (delayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        return new DelayStrategy(){
            private long misses = 0L;

            @Override
            public boolean sleepWhen(boolean criteria) {
                if (!criteria) {
                    this.misses = 0L;
                    return false;
                }
                ++this.misses;
                try {
                    Thread.sleep(this.misses * delayInMilliseconds);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        };
    }

    public static DelayStrategy exponential(Duration initialDelay, Duration maxDelay) {
        return DelayStrategy.exponential(initialDelay, maxDelay, 2.0);
    }

    public static DelayStrategy exponential(Duration initialDelay, Duration maxDelay, double backOffMultiplier) {
        return DelayStrategy.exponential(initialDelay, maxDelay, backOffMultiplier, false);
    }

    public static DelayStrategy boundedExponential(Duration initialDelay, Duration maxDelay, double backOffMultiplier) {
        return DelayStrategy.exponential(initialDelay, maxDelay, backOffMultiplier, true);
    }

    public static DelayStrategy exponential(Duration initialDelay, Duration maxDelay, final double backOffMultiplier, final boolean bounded) {
        final long initialDelayInMilliseconds = initialDelay.toMillis();
        final long maxDelayInMilliseconds = maxDelay.toMillis();
        if (backOffMultiplier <= 1.0) {
            throw new IllegalArgumentException("Backup multiplier must be greater than 1");
        }
        if (initialDelayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        if (initialDelayInMilliseconds >= maxDelayInMilliseconds) {
            throw new IllegalArgumentException("Maximum delay must be greater than initial delay");
        }
        return new DelayStrategy(){
            private long previousDelay = 0L;

            @Override
            public boolean sleepWhen(boolean criteria) {
                if (!criteria || this.maxDelayedReached()) {
                    this.previousDelay = 0L;
                    return false;
                }
                if (this.previousDelay == 0L) {
                    this.previousDelay = initialDelayInMilliseconds;
                } else {
                    long nextDelay = (long)((double)this.previousDelay * backOffMultiplier);
                    this.previousDelay = Math.min(nextDelay, maxDelayInMilliseconds);
                }
                try {
                    Thread.sleep(this.previousDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }

            private boolean maxDelayedReached() {
                return bounded && this.previousDelay >= maxDelayInMilliseconds;
            }
        };
    }
}

