/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.Configuration;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class Instantiator {
    public static <T> T getInstance(String className) {
        return Instantiator.getInstanceWithProvidedConstructorType(className, null, null);
    }

    public static <T> T getInstance(String className, Configuration configuration) {
        return Instantiator.getInstanceWithProvidedConstructorType(className, Configuration.class, configuration);
    }

    public static <T> T getInstanceWithProperties(String className, Properties prop) {
        return Instantiator.getInstanceWithProvidedConstructorType(className, Properties.class, prop);
    }

    public static <T, C> T getInstanceWithProvidedConstructorType(String className, Class<C> constructorType, C constructorValue) {
        if (className != null) {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            if (classloader == null) {
                classloader = Configuration.class.getClassLoader();
            }
            try {
                Class<?> clazz = classloader.loadClass(className);
                return (T)(constructorValue == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getConstructor(constructorType).newInstance(constructorValue));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to find class " + className, e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instantiate class " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access class " + className, e);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Call to constructor of class " + className + " failed", e);
            }
        }
        return null;
    }
}

