/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.signal.AbstractSnapshotSignal;
import io.debezium.pipeline.signal.Signal;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionId;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopSnapshot<P extends Partition>
extends AbstractSnapshotSignal<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopSnapshot.class);
    public static final String NAME = "stop-snapshot";
    private final EventDispatcher<P, ? extends DataCollectionId> dispatcher;

    public StopSnapshot(EventDispatcher<P, ? extends DataCollectionId> dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public boolean arrived(Signal.Payload<P> signalPayload) throws InterruptedException {
        List<String> dataCollections = StopSnapshot.getDataCollections(signalPayload.data);
        AbstractSnapshotSignal.SnapshotType type = StopSnapshot.getSnapshotType(signalPayload.data);
        LOGGER.info("Requested stop of snapshot '{}' for data collections '{}'", (Object)type, dataCollections);
        switch (type) {
            case INCREMENTAL: {
                this.dispatcher.getIncrementalSnapshotChangeEventSource().stopSnapshot(signalPayload.partition, dataCollections, signalPayload.offsetContext);
            }
        }
        return true;
    }

    public static List<String> getDataCollections(Document data) {
        Array dataCollectionsArray = data.getArray("data-collections");
        if (dataCollectionsArray == null || dataCollectionsArray.isEmpty()) {
            return null;
        }
        return dataCollectionsArray.streamValues().map(v -> v.asString().trim()).collect(Collectors.toList());
    }
}

