/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParserListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

@NotThreadSafe
public class DdlChanges
implements DdlParserListener {
    private final List<DdlParserListener.Event> events = new ArrayList<DdlParserListener.Event>();
    private final Set<String> databaseNames = new HashSet<String>();

    public DdlChanges reset() {
        this.events.clear();
        this.databaseNames.clear();
        return this;
    }

    @Override
    public void handle(DdlParserListener.Event event) {
        this.events.add(event);
        this.databaseNames.add(this.getDatabase(event));
    }

    public void getEventsByDatabase(DatabaseEventConsumer consumer) {
        if (this.isEmpty()) {
            return;
        }
        if (this.databaseNames.size() <= 1) {
            consumer.consume(this.databaseNames.iterator().next(), this.events);
            return;
        }
        ArrayList<DdlParserListener.Event> dbEvents = new ArrayList<DdlParserListener.Event>();
        String currentDatabase = null;
        for (DdlParserListener.Event event : this.events) {
            String dbName = this.getDatabase(event);
            if (currentDatabase == null || dbName.equals(currentDatabase)) {
                currentDatabase = dbName;
                dbEvents.add(event);
                continue;
            }
            consumer.consume(currentDatabase, dbEvents);
            dbEvents = new ArrayList();
            currentDatabase = dbName;
            dbEvents.add(event);
        }
        if (!dbEvents.isEmpty()) {
            consumer.consume(currentDatabase, dbEvents);
        }
    }

    protected String getDatabase(DdlParserListener.Event event) {
        switch (event.type()) {
            case CREATE_TABLE: 
            case ALTER_TABLE: 
            case DROP_TABLE: 
            case TRUNCATE_TABLE: {
                DdlParserListener.TableEvent tableEvent = (DdlParserListener.TableEvent)event;
                return tableEvent.tableId().catalog();
            }
            case CREATE_INDEX: 
            case DROP_INDEX: {
                DdlParserListener.TableIndexEvent tableIndexEvent = (DdlParserListener.TableIndexEvent)event;
                return tableIndexEvent.tableId().catalog();
            }
            case CREATE_DATABASE: 
            case ALTER_DATABASE: 
            case DROP_DATABASE: 
            case USE_DATABASE: {
                DdlParserListener.DatabaseEvent dbEvent = (DdlParserListener.DatabaseEvent)event;
                return dbEvent.databaseName();
            }
            case SET_VARIABLE: {
                DdlParserListener.SetVariableEvent varEvent = (DdlParserListener.SetVariableEvent)event;
                return varEvent.databaseName().orElse("");
            }
        }
        assert (false) : "Should never happen";
        return null;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public String toString() {
        return this.events.toString();
    }

    @Deprecated
    public boolean anyMatch(Predicate<String> databaseFilter, Predicate<TableId> tableFilter) {
        return this.events.stream().anyMatch((? super T event) -> event instanceof DdlParserListener.DatabaseEvent && databaseFilter.test(((DdlParserListener.DatabaseEvent)event).databaseName()) || event instanceof DdlParserListener.TableEvent && tableFilter.test(((DdlParserListener.TableEvent)event).tableId()) || event instanceof DdlParserListener.SetVariableEvent && (!((DdlParserListener.SetVariableEvent)event).databaseName().isPresent() || databaseFilter.test(((DdlParserListener.SetVariableEvent)event).databaseName().get())));
    }

    public boolean anyMatch(RelationalTableFilters filters) {
        Predicate<String> databaseFilter = filters.databaseFilter();
        Tables.TableFilter tableFilter = filters.dataCollectionFilter();
        return this.events.stream().anyMatch((? super T event) -> event instanceof DdlParserListener.DatabaseEvent && databaseFilter.test(((DdlParserListener.DatabaseEvent)event).databaseName()) || event instanceof DdlParserListener.TableEvent && tableFilter.isIncluded(((DdlParserListener.TableEvent)event).tableId()) || event instanceof DdlParserListener.SetVariableEvent && (!((DdlParserListener.SetVariableEvent)event).databaseName().isPresent() || databaseFilter.test(((DdlParserListener.SetVariableEvent)event).databaseName().get())));
    }

    public static interface DatabaseEventConsumer {
        public void consume(String var1, List<DdlParserListener.Event> var2);
    }
}

