/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.spi.converter.ConvertedField;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.data.SchemaBuilder;

@ThreadSafe
public class CustomConverterRegistry {
    @Immutable
    private final List<CustomConverter<SchemaBuilder, ConvertedField>> converters;
    private final Map<String, ConverterDefinition<SchemaBuilder>> conversionFunctionMap = new HashMap<String, ConverterDefinition<SchemaBuilder>>();

    public CustomConverterRegistry(List<CustomConverter<SchemaBuilder, ConvertedField>> converters) {
        this.converters = converters == null ? Collections.emptyList() : Collections.unmodifiableList(converters);
    }

    public synchronized Optional<SchemaBuilder> registerConverterFor(final TableId table, final Column column, final Object defaultValue) {
        String fullColumnName = this.fullColumnName(table, column);
        for (CustomConverter<SchemaBuilder, ConvertedField> converter : this.converters) {
            final AtomicReference definition = new AtomicReference();
            converter.converterFor((ConvertedField)new RelationalColumn(){

                public String name() {
                    return column.name();
                }

                public String dataCollection() {
                    return table.toString();
                }

                public String typeName() {
                    return column.typeName();
                }

                public String typeExpression() {
                    return column.typeExpression();
                }

                public OptionalInt scale() {
                    return column.scale().isPresent() ? OptionalInt.of(column.scale().get()) : OptionalInt.empty();
                }

                public int nativeType() {
                    return column.nativeType();
                }

                public OptionalInt length() {
                    return column.length() == -1 ? OptionalInt.empty() : OptionalInt.of(column.length());
                }

                public int jdbcType() {
                    return column.jdbcType();
                }

                public boolean isOptional() {
                    return column.isOptional();
                }

                public boolean hasDefaultValue() {
                    return column.hasDefaultValue();
                }

                public Object defaultValue() {
                    return defaultValue;
                }
            }, (CustomConverter.ConverterRegistration)new CustomConverter.ConverterRegistration<SchemaBuilder>(){

                public void register(SchemaBuilder fieldSchema, CustomConverter.Converter converter) {
                    definition.set(new ConverterDefinition<SchemaBuilder>(fieldSchema, converter));
                }
            });
            if (definition.get() == null) continue;
            this.conversionFunctionMap.put(fullColumnName, (ConverterDefinition)definition.get());
            return Optional.of((SchemaBuilder)((ConverterDefinition)definition.get()).fieldSchema);
        }
        this.conversionFunctionMap.remove(fullColumnName);
        return Optional.empty();
    }

    public Optional<ValueConverter> getValueConverter(TableId table, Column column) {
        ConverterDefinition<SchemaBuilder> converterDefinition = this.conversionFunctionMap.get(this.fullColumnName(table, column));
        if (converterDefinition == null) {
            return Optional.empty();
        }
        return Optional.of(x -> converterDefinition.converter.convert(x));
    }

    public boolean isEmpty() {
        return this.conversionFunctionMap.isEmpty();
    }

    private String fullColumnName(TableId table, Column column) {
        return table + "." + column.name();
    }

    public class ConverterDefinition<S> {
        public final S fieldSchema;
        public final CustomConverter.Converter converter;

        public ConverterDefinition(S fieldSchema, CustomConverter.Converter converter) {
            this.fieldSchema = fieldSchema;
            this.converter = converter;
        }
    }
}

