/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.signal.ExecuteSnapshot;
import io.debezium.pipeline.signal.Log;
import io.debezium.pipeline.signal.SchemaChanges;
import io.debezium.pipeline.source.snapshot.incremental.CloseIncrementalSnapshotWindow;
import io.debezium.pipeline.source.snapshot.incremental.OpenIncrementalSnapshotWindow;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.schema.DataCollectionId;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Signal {
    private static final Logger LOGGER = LoggerFactory.getLogger(Signal.class);
    private final CommonConnectorConfig connectorConfig;
    private final String signalDataCollectionId;
    private final EventDispatcher<? extends DataCollectionId> dispatcher;
    private final Map<String, Action> signalActions = new HashMap<String, Action>();

    public Signal(CommonConnectorConfig connectorConfig, EventDispatcher<? extends DataCollectionId> eventDispatcher) {
        this.connectorConfig = connectorConfig;
        this.signalDataCollectionId = connectorConfig.getSignalingDataCollectionId();
        this.dispatcher = eventDispatcher;
        this.registerSignalAction("log", new Log());
        if (connectorConfig instanceof HistorizedRelationalDatabaseConnectorConfig) {
            this.registerSignalAction("schema-changes", new SchemaChanges(this.dispatcher, ((HistorizedRelationalDatabaseConnectorConfig)connectorConfig).useCatalogBeforeSchema()));
        } else {
            this.registerSignalAction("schema-changes", new SchemaChanges(this.dispatcher, false));
        }
        this.registerSignalAction("execute-snapshot", new ExecuteSnapshot(this.dispatcher));
        this.registerSignalAction("snapshot-window-open", new OpenIncrementalSnapshotWindow());
        this.registerSignalAction("snapshot-window-close", new CloseIncrementalSnapshotWindow(this.dispatcher));
    }

    Signal(CommonConnectorConfig connectorConfig) {
        this(connectorConfig, null);
    }

    public boolean isSignal(DataCollectionId dataCollectionId) {
        return this.signalDataCollectionId != null && this.signalDataCollectionId.equals(dataCollectionId.identifier());
    }

    public void registerSignalAction(String id, Action signal) {
        LOGGER.debug("Registering signal '{}' using class '{}'", (Object)id, (Object)signal.getClass().getName());
        this.signalActions.put(id, signal);
    }

    public boolean process(Partition partition, String id, String type, String data, OffsetContext offset, Struct source) throws InterruptedException {
        LOGGER.debug("Arrived signal id = '{}', type = '{}', data = '{}'", new Object[]{id, type, data});
        Action action = this.signalActions.get(type);
        if (action == null) {
            LOGGER.warn("Signal '{}' has arrived but the type '{}' is not recognized", (Object)id, (Object)type);
            return false;
        }
        try {
            Document jsonData = data == null || data.isEmpty() ? Document.create() : DocumentReader.defaultReader().read(data);
            return action.arrived(new Payload(partition, id, type, jsonData, offset, source));
        }
        catch (IOException e) {
            LOGGER.warn("Signal '{}' has arrived but the data '{}' cannot be parsed", new Object[]{id, data, e});
            return false;
        }
    }

    public boolean process(Partition partition, String id, String type, String data) throws InterruptedException {
        return this.process(partition, id, type, data, null, null);
    }

    public boolean process(Partition partition, Struct value, OffsetContext offset) throws InterruptedException {
        String id = null;
        String type = null;
        String data = null;
        Struct source = null;
        try {
            List fields;
            Struct after = value.getStruct("after");
            if (after == null) {
                LOGGER.warn("After part of signal '{}' is missing", (Object)value);
                return false;
            }
            if (value.schema().field("source") != null) {
                source = value.getStruct("source");
            }
            if ((fields = after.schema().fields()).size() != 3) {
                LOGGER.warn("The signal event '{}' should have 3 fields but has {}", (Object)after, (Object)fields.size());
                return false;
            }
            id = after.getString(((Field)fields.get(0)).name());
            type = after.getString(((Field)fields.get(1)).name());
            data = after.getString(((Field)fields.get(2)).name());
        }
        catch (Exception e) {
            LOGGER.warn("Exception while preparing to process the signal '{}'", (Object)value, (Object)e);
        }
        return this.process(partition, id, type, data, offset, source);
    }

    public static class Payload {
        public final String id;
        public final String type;
        public final Document data;
        public final Partition partition;
        public final OffsetContext offsetContext;
        public final Struct source;

        public Payload(Partition partition, String id, String type, Document data, OffsetContext offsetContext, Struct source) {
            this.partition = partition;
            this.id = id;
            this.type = type;
            this.data = data;
            this.offsetContext = offsetContext;
            this.source = source;
        }

        public String toString() {
            return "Payload [id=" + this.id + ", type=" + this.type + ", data=" + this.data + ", offsetContext=" + this.offsetContext + ", source=" + this.source + "]";
        }
    }

    @FunctionalInterface
    public static interface Action {
        public boolean arrived(Payload var1) throws InterruptedException;
    }
}

