/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.DataCollectionFilters;
import java.util.function.Predicate;

public class RelationalTableFilters
implements DataCollectionFilters {
    private final Tables.TableFilter tableFilter;
    private final String excludeColumns;

    public RelationalTableFilters(Configuration config, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper) {
        Predicate<TableId> predicate = Selectors.tableSelector().includeSchemas(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, RelationalDatabaseConnectorConfig.SCHEMA_WHITELIST)).excludeSchemas(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.SCHEMA_BLACKLIST)).includeTables(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_WHITELIST), tableIdMapper).excludeTables(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST), tableIdMapper).build();
        Predicate<TableId> finalPredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? predicate.and(systemTablesFilter::isIncluded) : predicate;
        this.tableFilter = finalPredicate::test;
        this.excludeColumns = config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST);
    }

    public Tables.TableFilter dataCollectionFilter() {
        return this.tableFilter;
    }

    public String getExcludeColumns() {
        return this.excludeColumns;
    }
}

