/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.metrics.PipelineMetrics;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.TableId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class SnapshotChangeEventSourceMetrics
extends PipelineMetrics
implements SnapshotChangeEventSourceMetricsMXBean,
SnapshotProgressListener {
    private final AtomicBoolean snapshotRunning = new AtomicBoolean();
    private final AtomicBoolean snapshotCompleted = new AtomicBoolean();
    private final AtomicBoolean snapshotAborted = new AtomicBoolean();
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicLong stopTime = new AtomicLong();
    private final ConcurrentMap<String, Long> rowsScanned = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, String> remainingTables = new ConcurrentHashMap<String, String>();
    private final Set<String> monitoredTables = Collections.synchronizedSet(new HashSet());

    public <T extends CdcSourceTaskContext> SnapshotChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, "snapshot", changeEventQueueMetrics, metadataProvider);
    }

    @Override
    public int getTotalTableCount() {
        return this.monitoredTables.size();
    }

    @Override
    public int getRemainingTableCount() {
        return this.remainingTables.size();
    }

    @Override
    public boolean getSnapshotRunning() {
        return this.snapshotRunning.get();
    }

    @Override
    public boolean getSnapshotCompleted() {
        return this.snapshotCompleted.get();
    }

    @Override
    public boolean getSnapshotAborted() {
        return this.snapshotAborted.get();
    }

    @Override
    public long getSnapshotDurationInSeconds() {
        long startMillis = this.startTime.get();
        if (startMillis <= 0L) {
            return 0L;
        }
        long stopMillis = this.stopTime.get();
        if (stopMillis == 0L) {
            stopMillis = this.clock.currentTimeInMillis();
        }
        return (stopMillis - startMillis) / 1000L;
    }

    @Override
    public String[] getMonitoredTables() {
        return this.monitoredTables.toArray(new String[this.monitoredTables.size()]);
    }

    @Override
    public void monitoredTablesDetermined(Iterable<TableId> tableIds) {
        for (TableId tableId : tableIds) {
            this.remainingTables.put(tableId.toString(), "");
            this.monitoredTables.add(tableId.toString());
        }
    }

    @Override
    public void tableSnapshotCompleted(TableId tableId, long numRows) {
        this.rowsScanned.put(tableId.toString(), numRows);
        this.remainingTables.remove(tableId.toString());
    }

    @Override
    public void snapshotStarted() {
        this.snapshotRunning.set(true);
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(false);
        this.startTime.set(this.clock.currentTimeInMillis());
        this.stopTime.set(0L);
    }

    @Override
    public void snapshotCompleted() {
        this.snapshotCompleted.set(true);
        this.snapshotAborted.set(false);
        this.snapshotRunning.set(false);
        this.stopTime.set(this.clock.currentTimeInMillis());
    }

    @Override
    public void snapshotAborted() {
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(true);
        this.snapshotRunning.set(false);
        this.stopTime.set(this.clock.currentTimeInMillis());
    }

    @Override
    public void rowsScanned(TableId tableId, long numRows) {
        this.rowsScanned.put(tableId.toString(), numRows);
    }

    public ConcurrentMap<String, Long> getRowsScanned() {
        return this.rowsScanned;
    }

    @Override
    public void reset() {
        super.reset();
        this.snapshotRunning.set(false);
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(false);
        this.startTime.set(0L);
        this.stopTime.set(0L);
        this.rowsScanned.clear();
        this.remainingTables.clear();
        this.monitoredTables.clear();
    }
}

