/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector;

import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public abstract class AbstractSourceInfo {
    public static final String DEBEZIUM_VERSION_KEY = "version";
    public static final String DEBEZIUM_CONNECTOR_KEY = "connector";
    private final String version;

    protected static SchemaBuilder schemaBuilder() {
        return SchemaBuilder.struct().field(DEBEZIUM_VERSION_KEY, Schema.OPTIONAL_STRING_SCHEMA).field(DEBEZIUM_CONNECTOR_KEY, Schema.OPTIONAL_STRING_SCHEMA);
    }

    protected AbstractSourceInfo(String version) {
        this.version = Objects.requireNonNull(version);
    }

    protected abstract Schema schema();

    protected abstract String connector();

    protected Struct struct() {
        return new Struct(this.schema()).put(DEBEZIUM_VERSION_KEY, (Object)this.version).put(DEBEZIUM_CONNECTOR_KEY, (Object)this.connector());
    }
}

