/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.Value;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class TableChanges
implements Iterable<TableChange> {
    private final List<TableChange> changes = new ArrayList<TableChange>();

    public static TableChanges fromArray(Array array) {
        TableChanges tableChanges = new TableChanges();
        for (Array.Entry entry : array) {
            TableChange change = TableChange.fromDocument(entry.getValue().asDocument());
            if (change.getType() == TableChangeType.CREATE) {
                tableChanges.create(change.table);
                continue;
            }
            if (change.getType() != TableChangeType.ALTER) continue;
            tableChanges.alter(change.table);
        }
        return tableChanges;
    }

    public TableChanges create(Table table) {
        this.changes.add(new TableChange(TableChangeType.CREATE, table));
        return this;
    }

    public TableChanges alter(Table table) {
        this.changes.add(new TableChange(TableChangeType.ALTER, table));
        return this;
    }

    @Override
    public Iterator<TableChange> iterator() {
        return this.changes.iterator();
    }

    public Array toArray() {
        List<Value> values = this.changes.stream().map(TableChange::toDocument).map(Value::create).collect(Collectors.toList());
        return Array.create(values);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.changes.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableChanges other = (TableChanges)obj;
        return this.changes.equals(other.changes);
    }

    public String toString() {
        return "TableChanges [changes=" + this.changes + "]";
    }

    public static enum TableChangeType {
        CREATE,
        ALTER,
        DROP;

    }

    public static class TableChange {
        private final TableChangeType type;
        private final TableId id;
        private final Table table;

        public TableChange(TableChangeType type, Table table) {
            this.type = type;
            this.table = table;
            this.id = table.id();
        }

        public static TableChange fromDocument(Document document) {
            TableChangeType type = TableChangeType.valueOf(document.getString("type"));
            TableId id = TableId.parse(document.getString("id"));
            Table table = null;
            if (type == TableChangeType.CREATE || type == TableChangeType.ALTER) {
                table = TableChange.fromDocument(id, document.getDocument("table"));
            }
            return new TableChange(type, table);
        }

        public TableChangeType getType() {
            return this.type;
        }

        public TableId getId() {
            return this.id;
        }

        public Table getTable() {
            return this.table;
        }

        public Document toDocument() {
            Document document = Document.create();
            document.setString("type", this.type.name());
            document.setString("id", this.id.toDoubleQuotedString());
            document.setDocument("table", this.toDocument(this.table));
            return document;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableChange other = (TableChange)obj;
            if (!this.id.equals(other.id)) {
                return false;
            }
            if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "TableChange [type=" + (Object)((Object)this.type) + ", id=" + this.id + ", table=" + this.table + "]";
        }

        private Document toDocument(Table table) {
            Document document = Document.create();
            document.set("defaultCharsetName", table.defaultCharsetName());
            document.set("primaryKeyColumnNames", Array.create(table.primaryKeyColumnNames()));
            List columns = table.columns().stream().map(this::toDocument).collect(Collectors.toList());
            document.setArray((CharSequence)"columns", Array.create(columns));
            return document;
        }

        private Document toDocument(Column column) {
            Document document = Document.create();
            document.setString("name", column.name());
            document.setNumber((CharSequence)"jdbcType", column.jdbcType());
            if (column.nativeType() != -1) {
                document.setNumber((CharSequence)"nativeType", column.nativeType());
            }
            document.setString("typeName", column.typeName());
            document.setString("typeExpression", column.typeExpression());
            document.setString("charsetName", column.charsetName());
            if (column.length() != -1) {
                document.setNumber((CharSequence)"length", column.length());
            }
            column.scale().ifPresent(s -> document.setNumber((CharSequence)"scale", (int)s));
            document.setNumber((CharSequence)"position", column.position());
            document.setBoolean("optional", column.isOptional());
            document.setBoolean("autoIncremented", column.isAutoIncremented());
            document.setBoolean("generated", column.isGenerated());
            return document;
        }

        private static Table fromDocument(TableId id, Document document) {
            TableEditor editor = Table.editor().tableId(id).setDefaultCharsetName(document.getString("defaultCharsetName"));
            document.getArray("columns").streamValues().map(Value::asDocument).map(v -> {
                Integer scale;
                ColumnEditor columnEditor = Column.editor().name(v.getString("name")).jdbcType(v.getInteger("jdbcType"));
                Integer nativeType = v.getInteger("nativeType");
                if (nativeType != null) {
                    columnEditor.nativeType(nativeType);
                }
                columnEditor.type(v.getString("typeName"), v.getString("typeExpression")).charsetName(v.getString("charsetName"));
                Integer length = v.getInteger("length");
                if (length != null) {
                    columnEditor.length(length);
                }
                if ((scale = v.getInteger("scale")) != null) {
                    columnEditor.scale(scale);
                }
                columnEditor.position(v.getInteger("position")).optional(v.getBoolean("optional")).autoIncremented(v.getBoolean("autoIncremented")).generated(v.getBoolean("generated"));
                return columnEditor.create();
            }).forEach(editor::addColumn);
            editor.setPrimaryKeyNames(document.getArray("primaryKeyColumnNames").streamValues().map(Value::asString).collect(Collectors.toList()));
            return editor.create();
        }
    }
}

