/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.relational.Table;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SchemaChangeEvent {
    private final String database;
    private final String schema;
    private final String ddl;
    private final Set<Table> tables;
    private final SchemaChangeEventType type;
    private final Map<String, ?> partition;
    private final Map<String, ?> offset;
    private final boolean isFromSnapshot;

    public SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, String database, String schema, String ddl, Table table, SchemaChangeEventType type, boolean isFromSnapshot) {
        this(partition, offset, database, schema, ddl, table != null ? Collections.singleton(table) : null, type, isFromSnapshot);
    }

    public SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, String database, String schema, String ddl, Set<Table> tables, SchemaChangeEventType type, boolean isFromSnapshot) {
        this.partition = Objects.requireNonNull(partition, "partition must not be null");
        this.offset = Objects.requireNonNull(offset, "offset must not be null");
        this.database = Objects.requireNonNull(database, "database must not be null");
        this.schema = Objects.requireNonNull(schema, "schema must not be null");
        this.ddl = Objects.requireNonNull(ddl, "ddl must not be null");
        this.tables = Objects.requireNonNull(tables, "tables must not be null");
        this.type = Objects.requireNonNull(type, "type must not be null");
        this.isFromSnapshot = isFromSnapshot;
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        return this.offset;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDdl() {
        return this.ddl;
    }

    public Set<Table> getTables() {
        return this.tables;
    }

    public SchemaChangeEventType getType() {
        return this.type;
    }

    public boolean isFromSnapshot() {
        return this.isFromSnapshot;
    }

    public String toString() {
        return "SchemaChangeEvent [ddl=" + this.ddl + ", tables=" + this.tables + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum SchemaChangeEventType {
        CREATE,
        ALTER,
        DROP;

    }
}

