/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.ddl.DdlTokenizer;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.text.Position;
import io.debezium.text.TokenStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LegacyDdlParser
extends AbstractDdlParser
implements DdlParser {
    private final Set<String> keywords = new HashSet<String>();
    private final Set<String> statementStarts = new HashSet<String>();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final DataTypeParser dataTypeParser = new DataTypeParser();
    protected Tables databaseTables;
    protected TokenStream tokens;
    private final List<DdlParserListener> listeners = new CopyOnWriteArrayList<DdlParserListener>();

    public LegacyDdlParser(String terminator) {
        this(terminator, false);
    }

    public LegacyDdlParser(String terminator, boolean includeViews) {
        super(terminator, includeViews);
        this.initializeDataTypes(this.dataTypeParser);
        this.initializeKeywords(this.keywords::add);
        this.initializeStatementStarts(this.statementStarts::add);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new SystemVariables();
    }

    protected void initializeDataTypes(DataTypeParser dataTypeParser) {
    }

    protected void initializeKeywords(TokenSet keywords) {
    }

    protected void initializeStatementStarts(TokenSet statementStartTokens) {
        statementStartTokens.add("CREATE", "ALTER", "DROP", "INSERT", "SET", "GRANT", "REVOKE");
    }

    public void addListener(DdlParserListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(DdlParserListener listener) {
        return listener != null && this.listeners.remove(listener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    protected boolean isNextTokenQuotedIdentifier() {
        return this.tokens.matchesAnyOf(8, 16);
    }

    protected int determineTokenType(int type, String token) {
        if (this.statementStarts.contains(token)) {
            type |= 0x80;
        }
        if (this.keywords.contains(token)) {
            type |= 0x40;
        }
        if (this.terminator().equals(token)) {
            type |= 0x100;
        }
        return type;
    }

    protected String parseSchemaQualifiedName(TokenStream.Marker start) {
        String first = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String second = this.tokens.consume();
            return first + "." + second;
        }
        if (this.currentSchema() != null) {
            return this.currentSchema() + "." + first;
        }
        return first;
    }

    protected TableId parseQualifiedTableName(TokenStream.Marker start) {
        String name = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String tableName = this.tokens.consume();
            return this.resolveTableId(name, tableName);
        }
        return this.resolveTableId(this.currentSchema(), name);
    }

    protected List<TableId> parseQualifiedTableNames(TokenStream.Marker start) {
        LinkedList<TableId> ids = new LinkedList<TableId>();
        TableId id = this.parseQualifiedTableName(start);
        if (id != null) {
            ids.add(id);
        }
        while (this.tokens.canConsume(',')) {
            id = this.parseQualifiedTableName(start);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    @Override
    public final void parse(String ddlContent, Tables databaseTables) {
        TokenStream stream = new TokenStream(ddlContent, new DdlTokenizer(!this.skipComments(), this::determineTokenType), false);
        stream.start();
        this.parse(stream, databaseTables);
    }

    public final void parse(TokenStream ddlContent, Tables databaseTables) throws ParsingException, IllegalStateException {
        this.tokens = ddlContent;
        this.databaseTables = databaseTables;
        TokenStream.Marker marker = ddlContent.mark();
        try {
            while (ddlContent.hasNext()) {
                this.parseNextStatement(ddlContent.mark());
                this.tokens.canConsume(256);
            }
        }
        catch (ParsingException e) {
            ddlContent.rewind(marker);
            throw new ParsingException(e.getPosition(), "Failed to parse statement '" + ddlContent.getInputString() + "'", e);
        }
        catch (Throwable t) {
            this.parsingFailed(ddlContent.hasNext() ? ddlContent.nextPosition() : null, "Unexpected exception while parsing statement " + ddlContent.getInputString(), t);
        }
    }

    protected void parseNextStatement(TokenStream.Marker marker) {
        if (this.tokens.matches(32)) {
            this.parseComment(marker);
        } else if (this.tokens.matches("CREATE")) {
            this.parseCreate(marker);
        } else if (this.tokens.matches("ALTER")) {
            this.parseAlter(marker);
        } else if (this.tokens.matches("DROP")) {
            this.parseDrop(marker);
        } else {
            this.parseUnknownStatement(marker);
        }
    }

    protected void parseComment(TokenStream.Marker marker) {
        String comment = this.tokens.consume();
        this.commentParsed(comment);
    }

    protected void parseCreate(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseAlter(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseDrop(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseUnknownStatement(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void signalCreateDatabase(String databaseName, TokenStream.Marker statementStart) {
        this.signalCreateDatabase(databaseName, this.statement(statementStart));
    }

    @Override
    protected void signalChangeEvent(DdlParserListener.Event event) {
        if (event != null && !this.listeners.isEmpty()) {
            this.listeners.forEach(listener -> listener.handle(event));
        }
        super.signalChangeEvent(event);
    }

    protected void signalAlterDatabase(String databaseName, String previousDatabaseName, TokenStream.Marker statementStart) {
        this.signalAlterDatabase(databaseName, previousDatabaseName, this.statement(statementStart));
    }

    protected void signalDropDatabase(String databaseName, TokenStream.Marker statementStart) {
        this.signalDropDatabase(databaseName, this.statement(statementStart));
    }

    protected void signalCreateTable(TableId id, TokenStream.Marker statementStart) {
        this.signalCreateTable(id, this.statement(statementStart));
    }

    protected void signalAlterTable(TableId id, TableId previousId, TokenStream.Marker statementStart) {
        this.signalAlterTable(id, previousId, this.statement(statementStart));
    }

    protected void signalDropTable(TableId id, TokenStream.Marker statementStart) {
        this.signalDropTable(id, this.statement(statementStart));
    }

    protected void signalCreateView(TableId id, TokenStream.Marker statementStart) {
        this.signalChangeEvent(new DdlParserListener.TableCreatedEvent(id, this.statement(statementStart), true));
    }

    protected void signalAlterView(TableId id, TableId previousId, TokenStream.Marker statementStart) {
        this.signalAlterView(id, previousId, this.statement(statementStart));
    }

    protected void signalDropView(TableId id, TokenStream.Marker statementStart) {
        this.signalDropView(id, this.statement(statementStart));
    }

    protected void signalCreateIndex(String indexName, TableId id, TokenStream.Marker statementStart) {
        this.signalCreateIndex(indexName, id, this.statement(statementStart));
    }

    protected void signalDropIndex(String indexName, TableId id, TokenStream.Marker statementStart) {
        this.signalDropIndex(indexName, id, this.statement(statementStart));
    }

    protected void debugParsed(TokenStream.Marker statementStart) {
        this.debugParsed(this.statement(statementStart));
    }

    protected void debugSkipped(TokenStream.Marker statementStart) {
        this.debugSkipped(this.statement(statementStart));
    }

    protected String statement(TokenStream.Marker statementStart) {
        return this.removeLineFeeds(this.tokens.getContentFrom(statementStart));
    }

    protected void consumeStatement() throws ParsingException {
        TokenStream.Marker start = this.tokens.mark();
        this.tokens.consume(128);
        this.consumeRemainingStatement(start);
    }

    protected void consumeRemainingStatement(TokenStream.Marker start) {
        while (this.tokens.hasNext() && !this.tokens.matches(128)) {
            if (this.tokens.matchesWord("BEGIN")) {
                this.consumeBeginStatement(this.tokens.mark());
            } else if (this.tokens.matches(256)) {
                this.tokens.consume();
                break;
            }
            if (!this.tokens.hasNext()) {
                return;
            }
            this.tokens.consume();
        }
    }

    protected void consumeBeginStatement(TokenStream.Marker start) {
        this.tokens.consume("BEGIN");
        this.tokens.consumeThrough("END");
        while (this.tokens.canConsume("IF")) {
            this.tokens.consumeThrough("END");
        }
    }

    protected String consumeSingleQuotedString() {
        return this.tokens.consumeAnyOf(8);
    }

    protected String consumeDoubleQuotedString() {
        return this.tokens.consumeAnyOf(16);
    }

    protected String consumeQuotedString() {
        return this.tokens.consumeAnyOf(8, 16);
    }

    protected void parsingFailed(Position position, String msg) {
        this.parsingFailed(position, msg, null);
    }

    protected void parsingFailed(Position position, String msg, Throwable t) {
        if (position != null) {
            throw new ParsingException(position, msg + " at line " + position.line() + ", column " + position.column(), t);
        }
        throw new ParsingException(null, msg, t);
    }

    protected void parsingFailed(Position position, Collection<ParsingException> errors, String msg) {
        if (errors == null || errors.isEmpty()) {
            throw new ParsingException(position, msg + " at line " + position.line() + ", column " + position.column());
        }
        throw new MultipleParsingExceptions(msg + " at line " + position.line() + ", column " + position.column(), errors);
    }

    protected Object parseLiteral(TokenStream.Marker start) {
        if (this.tokens.canConsume('_')) {
            this.parseCharacterSetName(start);
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("N")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("U", "&")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("X")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.matchesAnyOf(16, 8)) {
            return this.tokens.consume();
        }
        if (this.tokens.canConsume("B")) {
            return this.parseBitFieldLiteral(start);
        }
        if (this.tokens.canConsume("DATE")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TIME")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TIMESTAMP")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TRUE")) {
            return Boolean.TRUE;
        }
        if (this.tokens.canConsume("FALSE")) {
            return Boolean.FALSE;
        }
        if (this.tokens.canConsume("UNKNOWN")) {
            return Boolean.FALSE;
        }
        return this.parseNumericLiteral(start, true);
    }

    protected Object parseNumericLiteral(TokenStream.Marker start, boolean signed) {
        StringBuilder sb = new StringBuilder();
        boolean decimal = false;
        if (signed && this.tokens.matchesAnyOf("+", "-")) {
            sb.append(this.tokens.consumeAnyOf("+", "-"));
        }
        if (!this.tokens.canConsume('.')) {
            sb.append(this.tokens.consumeInteger());
        }
        if (this.tokens.canConsume('.')) {
            sb.append('.');
            sb.append(this.tokens.consumeInteger());
            decimal = true;
        }
        if (!this.tokens.canConsumeAnyOf("E", "e")) {
            if (decimal) {
                return Double.parseDouble(sb.toString());
            }
            return Integer.parseInt(sb.toString());
        }
        sb.append('E');
        if (this.tokens.matchesAnyOf("+", "-")) {
            sb.append(this.tokens.consumeAnyOf("+", "-"));
        }
        sb.append(this.tokens.consumeInteger());
        return new BigDecimal(sb.toString());
    }

    protected String parseCharacterLiteral(TokenStream.Marker start) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (this.tokens.matches(32)) {
                this.parseComment(start);
                continue;
            }
            if (!this.tokens.matchesAnyOf(8, 16)) break;
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(this.tokens.consume());
        }
        if (this.tokens.canConsume("ESCAPE")) {
            this.tokens.consume();
        }
        return sb.toString();
    }

    protected String parseCharacterSetName(TokenStream.Marker start) {
        String name = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String id = this.tokens.consume();
            return name + "." + id;
        }
        return name;
    }

    protected String parseBitFieldLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseDateLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseTimeLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseTimestampLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected Map<String, Column> parseColumnsInSelectClause(TokenStream.Marker start) {
        LinkedHashMap<String, String> tableAliasByColumnAlias = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> columnNameByAliases = new LinkedHashMap<String, String>();
        this.parseColumnName(start, tableAliasByColumnAlias, columnNameByAliases);
        while (this.tokens.canConsume(',')) {
            this.parseColumnName(start, tableAliasByColumnAlias, columnNameByAliases);
        }
        TokenStream.Marker startOfFrom = this.tokens.mark();
        LinkedHashMap<String, Column> columnsByName = new LinkedHashMap<String, Column>();
        Map<String, Table> fromTablesByAlias = this.parseSelectFromClause(start);
        Table singleTable = fromTablesByAlias.size() == 1 ? fromTablesByAlias.values().stream().findFirst().get() : null;
        tableAliasByColumnAlias.forEach((columnAlias, tableAlias) -> {
            String columnName = columnNameByAliases.getOrDefault(columnAlias, (String)columnAlias);
            Column column = null;
            if (tableAlias == null) {
                column = singleTable == null ? null : singleTable.columnWithName(columnName);
            } else {
                Table table = (Table)fromTablesByAlias.get(tableAlias);
                Column column2 = column = table == null ? null : table.columnWithName(columnName);
            }
            if (column == null) {
                column = this.createColumnFromConstant((String)columnAlias, columnName);
            }
            columnsByName.put((String)columnAlias, column);
        });
        this.tokens.rewind(startOfFrom);
        return columnsByName;
    }

    protected String determineTypeNameForConstant(long value) {
        return "BIGINT";
    }

    protected String determineTypeNameForConstant(float value) {
        return "FLOAT";
    }

    protected String determineTypeNameForConstant(double value) {
        return "DECIMAL";
    }

    protected String determineTypeNameForConstant(BigDecimal value) {
        return "BIGINT";
    }

    protected void parseColumnName(TokenStream.Marker start, Map<String, String> tableAliasByColumnAliases, Map<String, String> columnNameByAliases) {
        try {
            String tableName = this.tokens.consume();
            String columnName = null;
            if (this.tokens.canConsume('.')) {
                columnName = this.tokens.consume();
            } else {
                columnName = tableName;
                tableName = null;
            }
            String alias = columnName;
            if (this.tokens.canConsume("AS")) {
                alias = this.tokens.consume();
            }
            columnNameByAliases.put(alias, columnName);
            tableAliasByColumnAliases.put(alias, tableName);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    protected Map<String, Table> parseSelectFromClause(TokenStream.Marker start) {
        HashMap<String, Table> tablesByAlias = new HashMap<String, Table>();
        if (this.tokens.canConsume("FROM")) {
            try {
                this.parseAliasedTableInFrom(start, tablesByAlias);
                while (this.tokens.canConsume(',') || this.canConsumeJoin(start)) {
                    this.parseAliasedTableInFrom(start, tablesByAlias);
                    this.canConsumeJoinCondition(start);
                }
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return tablesByAlias;
    }

    protected boolean canConsumeJoin(TokenStream.Marker start) {
        return this.tokens.canConsume("JOIN") || this.tokens.canConsume("INNER", "JOIN") || this.tokens.canConsume("OUTER", "JOIN") || this.tokens.canConsume("CROSS", "JOIN") || this.tokens.canConsume("RIGHT", "OUTER", "JOIN") || this.tokens.canConsume("LEFT", "OUTER", "JOIN") || this.tokens.canConsume("FULL", "OUTER", "JOIN");
    }

    protected boolean canConsumeJoinCondition(TokenStream.Marker start) {
        if (this.tokens.canConsume("ON")) {
            try {
                this.parseSchemaQualifiedName(start);
                while (this.tokens.canConsume(2)) {
                }
                this.parseSchemaQualifiedName(start);
                return true;
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return false;
    }

    private void parseAliasedTableInFrom(TokenStream.Marker start, Map<String, Table> tablesByAlias) {
        Table fromTable = this.databaseTables.forTable(this.parseQualifiedTableName(start));
        if (this.tokens.matches("AS", "any value", "ON") || this.tokens.matches("any value", "ON")) {
            this.tokens.canConsume("AS");
            String alias = this.tokens.consume();
            if (fromTable != null) {
                tablesByAlias.put(alias, fromTable);
                return;
            }
        }
        if (fromTable != null) {
            tablesByAlias.put(fromTable.id().table(), fromTable);
        }
    }

    protected static interface TokenSet {
        public void add(String var1);

        default public void add(String firstToken, String ... additionalTokens) {
            this.add(firstToken);
            for (String token : additionalTokens) {
                this.add(token);
            }
        }
    }
}

