/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import java.util.function.Predicate;

public class RelationalTableFilters
implements DataCollectionFilters {
    private final TableFilter tableFilter;

    public RelationalTableFilters(Configuration config, Predicate<TableId> systemTablesFilter) {
        Predicate<TableId> predicate = Selectors.tableSelector().includeTables(config.getString(RelationalDatabaseConnectorConfig.TABLE_WHITELIST)).excludeTables(config.getString(RelationalDatabaseConnectorConfig.TABLE_BLACKLIST)).build();
        Predicate<TableId> finalPredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? predicate.and(systemTablesFilter.negate()) : predicate;
        this.tableFilter = t -> finalPredicate.test(t);
    }

    public TableFilter dataCollectionFilter() {
        return this.tableFilter;
    }

    @FunctionalInterface
    public static interface TableFilter
    extends DataCollectionFilters.DataCollectionFilter<TableId> {
        @Override
        public boolean isIncluded(TableId var1);
    }
}

