/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.heartbeat;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.function.BlockingConsumer;
import io.debezium.heartbeat.HeartbeatImpl;
import io.debezium.heartbeat.OffsetPosition;
import java.time.temporal.ChronoUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceRecord;

public interface Heartbeat {
    public static final Field HEARTBEAT_INTERVAL = Field.create("heartbeat.interval.ms").withDisplayName("Conector heartbeat interval (milli-seconds)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.").withDefault(0).withValidation(Field::isNonNegativeInteger);
    public static final Field HEARTBEAT_TOPICS_PREFIX = Field.create("heartbeat.topics.prefix").withDisplayName("A prefix used for naming of heartbeat topics").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.").withDefault("__debezium-heartbeat");
    public static final Heartbeat NULL = new Heartbeat(){

        @Override
        public void heartbeat(BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        }

        @Override
        public void heartbeat(Consumer<SourceRecord> consumer) {
        }
    };

    public void heartbeat(Consumer<SourceRecord> var1);

    public void heartbeat(BlockingConsumer<SourceRecord> var1) throws InterruptedException;

    public static Heartbeat create(Configuration configuration, String topicName, String key, Supplier<OffsetPosition> positionSupplier) {
        return configuration.getDuration(HeartbeatImpl.HEARTBEAT_INTERVAL, ChronoUnit.MILLIS).isZero() ? NULL : new HeartbeatImpl(configuration, topicName, key, positionSupplier);
    }
}

