/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSourceTask
extends SourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSourceTask.class);

    public final void start(Map<String, String> props) {
        if (this.context == null) {
            throw new ConnectException("Unexpected null context");
        }
        Configuration config = Configuration.from(props);
        if (!config.validateAndRecord(this.getAllConfigurationFields(), arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        LOGGER.info("Starting " + ((Object)((Object)this)).getClass().getSimpleName() + " with configuration:");
        config.forEach((propName, propValue) -> LOGGER.info("   {} = {}", propName, propValue));
        this.start(config);
    }

    protected abstract void start(Configuration var1);

    protected abstract Iterable<Field> getAllConfigurationFields();
}

