/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class VariableScaleDecimal {
    public static final String LOGICAL_NAME = "io.debezium.data.VariableScaleDecimal";
    public static final String SCALE_FIELD = "scale";
    public static final String VALUE_FIELD = "value";

    public static SchemaBuilder builder() {
        return SchemaBuilder.struct().name(LOGICAL_NAME).version(Integer.valueOf(1)).doc("Variable scaled decimal").field(SCALE_FIELD, Schema.INT32_SCHEMA).field(VALUE_FIELD, Schema.BYTES_SCHEMA);
    }

    public static Schema schema() {
        return VariableScaleDecimal.builder().build();
    }

    public static Struct fromLogical(Schema schema, BigDecimal value) {
        Struct result = new Struct(schema);
        return result.put(SCALE_FIELD, (Object)value.scale()).put(VALUE_FIELD, (Object)value.unscaledValue().toByteArray());
    }

    public static BigDecimal toLogical(Struct value) {
        return new BigDecimal(new BigInteger(value.getBytes(VALUE_FIELD)), value.getInt32(SCALE_FIELD));
    }
}

