/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnection
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcConnection.class);
    private final Configuration config;
    private final ConnectionFactory factory;
    private final Operations initialOps;
    private volatile Connection conn;

    public static ConnectionFactory patternBasedFactory(String urlPattern, Field ... variables) {
        return config -> {
            LOGGER.trace("Config: {}", (Object)config.asProperties());
            Properties props = config.asProperties();
            Field[] varsWithDefaults = JdbcConnection.combineVariables(variables, JdbcConfiguration.HOSTNAME, JdbcConfiguration.PORT, JdbcConfiguration.USER, JdbcConfiguration.PASSWORD, JdbcConfiguration.DATABASE);
            String url = JdbcConnection.findAndReplace(urlPattern, props, varsWithDefaults);
            LOGGER.trace("Props: {}", (Object)props);
            LOGGER.trace("URL: {}", (Object)url);
            Connection conn = DriverManager.getConnection(url, props);
            LOGGER.debug("Connected to {} with {}", (Object)url, (Object)props);
            return conn;
        };
    }

    public static ConnectionFactory patternBasedFactory(String urlPattern, String driverClassName, ClassLoader classloader, Field ... variables) {
        return config -> {
            LOGGER.trace("Config: {}", (Object)config.asProperties());
            Properties props = config.asProperties();
            Field[] varsWithDefaults = JdbcConnection.combineVariables(variables, JdbcConfiguration.HOSTNAME, JdbcConfiguration.PORT, JdbcConfiguration.USER, JdbcConfiguration.PASSWORD, JdbcConfiguration.DATABASE);
            String url = JdbcConnection.findAndReplace(urlPattern, props, varsWithDefaults);
            LOGGER.trace("Props: {}", (Object)props);
            LOGGER.trace("URL: {}", (Object)url);
            Connection conn = null;
            try {
                ClassLoader driverClassLoader = classloader;
                if (driverClassLoader == null) {
                    driverClassLoader = JdbcConnection.class.getClassLoader();
                }
                Class<?> driverClazz = Class.forName(driverClassName, true, driverClassLoader);
                Driver driver = (Driver)driverClazz.newInstance();
                conn = driver.connect(url, props);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SQLException(e);
            }
            LOGGER.debug("Connected to {} with {}", (Object)url, (Object)props);
            return conn;
        };
    }

    private static Field[] combineVariables(Field[] overriddenVariables, Field ... defaultVariables) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        if (defaultVariables != null) {
            for (Field variable : defaultVariables) {
                fields.put(variable.name(), variable);
            }
        }
        if (overriddenVariables != null) {
            for (Field variable : overriddenVariables) {
                fields.put(variable.name(), variable);
            }
        }
        return fields.values().toArray(new Field[fields.size()]);
    }

    private static String findAndReplace(String url, Properties props, Field ... variables) {
        for (Field field : variables) {
            if (field == null) continue;
            url = JdbcConnection.findAndReplace(url, field.name(), props);
        }
        for (Object e : new HashSet<Object>(props.keySet())) {
            if (e == null) continue;
            url = JdbcConnection.findAndReplace(url, e.toString(), props);
        }
        return url;
    }

    private static String findAndReplace(String url, String name, Properties props) {
        String value;
        if (name != null && url.contains("${" + name + "}") && (value = props.getProperty(name)) != null) {
            props.remove(name);
            url = url.replaceAll("\\$\\{" + name + "\\}", value);
        }
        return url;
    }

    public JdbcConnection(Configuration config, ConnectionFactory connectionFactory) {
        this(config, connectionFactory, null);
    }

    public JdbcConnection(Configuration config, ConnectionFactory connectionFactory, Operations initialOperations) {
        this(config, connectionFactory, initialOperations, null);
    }

    protected JdbcConnection(Configuration config, ConnectionFactory connectionFactory, Operations initialOperations, Consumer<Configuration.Builder> adapter) {
        this.config = adapter == null ? config : ((Configuration.Builder)config.edit().apply((Consumer)adapter)).build();
        this.factory = connectionFactory;
        this.initialOps = initialOperations;
        this.conn = null;
    }

    public JdbcConfiguration config() {
        return JdbcConfiguration.adapt(this.config);
    }

    public JdbcConnection setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection().setAutoCommit(autoCommit);
        return this;
    }

    public JdbcConnection connect() throws SQLException {
        this.connection();
        return this;
    }

    public JdbcConnection execute(String ... sqlStatements) throws SQLException {
        return this.execute((Statement statement) -> {
            for (String sqlStatement : sqlStatements) {
                if (sqlStatement == null) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("executing '{}'", (Object)sqlStatement);
                }
                statement.execute(sqlStatement);
            }
        });
    }

    public JdbcConnection execute(Operations operations) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = conn.createStatement();){
            operations.apply(statement);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        return this;
    }

    public JdbcConnection query(String query, ResultSetConsumer resultConsumer) throws SQLException {
        return this.query(query, Connection::createStatement, resultConsumer);
    }

    public JdbcConnection call(String sql, CallPreparer callPreparer, ResultSetConsumer resultSetConsumer) throws SQLException {
        Connection conn = this.connection();
        try (CallableStatement callableStatement = conn.prepareCall(sql);){
            if (callPreparer != null) {
                callPreparer.accept(callableStatement);
            }
            try (ResultSet rs = callableStatement.executeQuery();){
                if (resultSetConsumer != null) {
                    resultSetConsumer.accept(rs);
                }
            }
        }
        return this;
    }

    public JdbcConnection query(String query, StatementFactory statementFactory, ResultSetConsumer resultConsumer) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = statementFactory.createStatement(conn);){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("running '{}'", (Object)query);
            }
            try (ResultSet resultSet = statement.executeQuery(query);){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString, StatementPreparer preparer, ResultSetConsumer resultConsumer) throws SQLException {
        Connection conn = this.connection();
        try (PreparedStatement statement = conn.prepareStatement(preparedQueryString);){
            preparer.accept(statement);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public JdbcConnection prepareUpdate(String stmt, StatementPreparer preparer) throws SQLException {
        Connection conn = this.connection();
        try (PreparedStatement statement = conn.prepareStatement(stmt);){
            if (preparer != null) {
                preparer.accept(statement);
            }
            statement.execute();
        }
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString, Collection<String> parameters, SingleParameterResultSetConsumer resultConsumer) throws SQLException {
        return this.prepareQuery(preparedQueryString, parameters.stream(), resultConsumer);
    }

    public JdbcConnection prepareQuery(String preparedQueryString, Stream<String> parameters, SingleParameterResultSetConsumer resultConsumer) throws SQLException {
        Connection conn = this.connection();
        try (PreparedStatement statement = conn.prepareStatement(preparedQueryString);){
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                statement.setString(1, value);
                boolean success = false;
                ResultSet resultSet = statement.executeQuery();
                Throwable throwable = null;
                try {
                    if (resultConsumer == null || (success = resultConsumer.accept(value, resultSet))) continue;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
        }
        return this;
    }

    public void print(ResultSet resultSet) {
        this.print(resultSet, System.out::println);
    }

    public void print(ResultSet resultSet, Consumer<String> lines) {
        try {
            int i;
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int[] columnSizes = this.findMaxLength(resultSet);
            lines.accept(this.delimiter(columnCount, columnSizes));
            StringBuilder sb = new StringBuilder();
            for (i = 1; i <= columnCount; ++i) {
                if (i > 1) {
                    sb.append(" | ");
                }
                sb.append(Strings.setLength(rsmd.getColumnLabel(i), columnSizes[i], ' '));
            }
            lines.accept(sb.toString());
            sb.setLength(0);
            lines.accept(this.delimiter(columnCount, columnSizes));
            while (resultSet.next()) {
                sb.setLength(0);
                for (i = 1; i <= columnCount; ++i) {
                    if (i > 1) {
                        sb.append(" | ");
                    }
                    sb.append(Strings.setLength(resultSet.getString(i), columnSizes[i], ' '));
                }
                lines.accept(sb.toString());
                sb.setLength(0);
            }
            lines.accept(this.delimiter(columnCount, columnSizes));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String delimiter(int columnCount, int[] columnSizes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= columnCount; ++i) {
            if (i > 1) {
                sb.append("---");
            }
            sb.append(Strings.createString('-', columnSizes[i]));
        }
        return sb.toString();
    }

    private int[] findMaxLength(ResultSet resultSet) throws SQLException {
        int i;
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int[] columnSizes = new int[columnCount + 1];
        for (i = 1; i <= columnCount; ++i) {
            columnSizes[i] = Math.max(columnSizes[i], rsmd.getColumnLabel(i).length());
        }
        while (resultSet.next()) {
            for (i = 1; i <= columnCount; ++i) {
                String value = resultSet.getString(i);
                if (value == null) continue;
                columnSizes[i] = Math.max(columnSizes[i], value.length());
            }
        }
        resultSet.beforeFirst();
        return columnSizes;
    }

    public synchronized boolean isConnected() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return !this.conn.isClosed();
    }

    public synchronized Connection connection() throws SQLException {
        if (this.conn == null) {
            this.conn = this.factory.connect(JdbcConfiguration.adapt(this.config));
            if (this.conn == null) {
                throw new SQLException("Unable to obtain a JDBC connection");
            }
            if (this.initialOps != null) {
                this.execute(this.initialOps);
            }
        }
        return this.conn;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            finally {
                this.conn = null;
            }
        }
    }

    public Set<String> readAllCatalogNames() throws SQLException {
        HashSet<String> catalogs = new HashSet<String>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getCatalogs();){
            while (rs.next()) {
                String catalogName = rs.getString(1);
                catalogs.add(catalogName);
            }
        }
        return catalogs;
    }

    public Set<String> readAllSchemaNames(Predicate<String> filter) throws SQLException {
        HashSet<String> schemas = new HashSet<String>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getSchemas();){
            while (rs.next()) {
                String schema = rs.getString(1);
                if (filter == null || !filter.test(schema)) continue;
                schemas.add(schema);
            }
        }
        return schemas;
    }

    public String[] tableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getTableTypes();){
            while (rs.next()) {
                String tableType = rs.getString(1);
                if (tableType == null) continue;
                types.add(tableType);
            }
        }
        return types.toArray(new String[types.size()]);
    }

    public Set<TableId> readAllTableNames(String[] tableTypes) throws SQLException {
        return this.readTableNames(null, null, null, tableTypes);
    }

    public Set<TableId> readTableNames(String databaseCatalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        HashSet<TableId> tableIds = new HashSet<TableId>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getTables(databaseCatalog, schemaNamePattern, tableNamePattern, tableTypes);){
            while (rs.next()) {
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String tableName = rs.getString(3);
                TableId tableId = new TableId(catalogName, schemaName, tableName);
                tableIds.add(tableId);
            }
        }
        return tableIds;
    }

    public String connectionString(String urlPattern) {
        Properties props = this.config.asProperties();
        return JdbcConnection.findAndReplace(urlPattern, props, JdbcConfiguration.DATABASE, JdbcConfiguration.HOSTNAME, JdbcConfiguration.PORT, JdbcConfiguration.USER, JdbcConfiguration.PASSWORD);
    }

    public String username() {
        return this.config.getString(JdbcConfiguration.USER);
    }

    public String database() {
        return this.config.getString(JdbcConfiguration.DATABASE);
    }

    protected int resolveComponentType(ResultSet rs) {
        return -1;
    }

    public void readSchema(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.TableNameFilter tableFilter, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc) throws SQLException {
        Object tableName;
        Object catalogName2;
        HashSet<TableId> tableIdsBefore = new HashSet<TableId>(tables.tableIds());
        DatabaseMetaData metadata = this.connection().getMetaData();
        HashSet<TableId> viewIds = new HashSet<TableId>();
        ResultSet rs = metadata.getTables(databaseCatalog, schemaNamePattern, null, new String[]{"VIEW"});
        Object object = null;
        try {
            while (rs.next()) {
                catalogName2 = rs.getString(1);
                String schemaName = rs.getString(2);
                String tableName2 = rs.getString(3);
                viewIds.add(new TableId((String)catalogName2, schemaName, tableName2));
            }
        }
        catch (Throwable catalogName2) {
            object = catalogName2;
            throw catalogName2;
        }
        finally {
            if (rs != null) {
                if (object != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable catalogName2) {
                        ((Throwable)object).addSuppressed(catalogName2);
                    }
                } else {
                    rs.close();
                }
            }
        }
        ConcurrentHashMap<TableId, List> columnsByTable = new ConcurrentHashMap<TableId, List>();
        ResultSet rs2 = metadata.getColumns(databaseCatalog, schemaNamePattern, null, null);
        catalogName2 = null;
        try {
            while (rs2.next()) {
                String schemaName;
                String catalogName3 = rs2.getString(1);
                TableId tableId = new TableId(catalogName3, schemaName = rs2.getString(2), (String)(tableName = rs2.getString(3)));
                if (viewIds.contains(tableId) || tableFilter != null && !tableFilter.matches(catalogName3, schemaName, (String)tableName)) continue;
                List cols = columnsByTable.computeIfAbsent(tableId, name -> new ArrayList());
                String columnName = rs2.getString(4);
                if (columnFilter != null && !columnFilter.matches(catalogName3, schemaName, (String)tableName, columnName)) continue;
                ColumnEditor column = Column.editor().name(columnName);
                column.jdbcType(rs2.getInt(5));
                column.type(rs2.getString(6));
                column.length(rs2.getInt(7));
                column.scale(rs2.getInt(9));
                column.optional(JdbcConnection.isNullable(rs2.getInt(11)));
                column.position(rs2.getInt(17));
                column.autoIncremented("YES".equalsIgnoreCase(rs2.getString(23)));
                String autogenerated = null;
                try {
                    autogenerated = rs2.getString(24);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                column.generated("YES".equalsIgnoreCase(autogenerated));
                if (column.jdbcType() == 2003) {
                    column.componentType(this.resolveComponentType(rs2));
                }
                cols.add(column.create());
            }
        }
        catch (Throwable catalogName3) {
            catalogName2 = catalogName3;
            throw catalogName3;
        }
        finally {
            if (rs2 != null) {
                if (catalogName2 != null) {
                    try {
                        rs2.close();
                    }
                    catch (Throwable catalogName3) {
                        ((Throwable)catalogName2).addSuppressed(catalogName3);
                    }
                } else {
                    rs2.close();
                }
            }
        }
        for (TableId id : columnsByTable.keySet()) {
            ArrayList<String> pkColumnNames = null;
            ResultSet rs3 = metadata.getPrimaryKeys(id.catalog(), id.schema(), id.table());
            tableName = null;
            try {
                while (rs3.next()) {
                    if (pkColumnNames == null) {
                        pkColumnNames = new ArrayList<String>();
                    }
                    String columnName = rs3.getString(4);
                    int columnIndex = rs3.getInt(5);
                    Collect.set(pkColumnNames, columnIndex - 1, columnName, null);
                }
            }
            catch (Throwable throwable) {
                tableName = throwable;
                throw throwable;
            }
            finally {
                if (rs3 != null) {
                    if (tableName != null) {
                        try {
                            rs3.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)tableName).addSuppressed(throwable);
                        }
                    } else {
                        rs3.close();
                    }
                }
            }
            List columns = (List)columnsByTable.get(id);
            Collections.sort(columns);
            String defaultCharsetName = null;
            tables.overwriteTable(id, columns, pkColumnNames, defaultCharsetName);
        }
        if (removeTablesNotFoundInJdbc) {
            tableIdsBefore.removeAll(columnsByTable.keySet());
            tableIdsBefore.forEach(tables::removeTable);
        }
    }

    public Map<String, Integer> readTypeInfo() throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        HashMap<String, Integer> jdbcTypeByLocalTypeName = new HashMap<String, Integer>();
        try (ResultSet rs = metadata.getTypeInfo();){
            while (rs.next()) {
                jdbcTypeByLocalTypeName.put(rs.getString("TYPE_NAME"), rs.getInt("DATA_TYPE"));
            }
        }
        return jdbcTypeByLocalTypeName;
    }

    public static void columnsFor(ResultSet resultSet, TableEditor editor) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        JdbcConnection.columnsFor(resultSet, columns::add);
        editor.setColumns(columns);
    }

    public static void columnsFor(ResultSet resultSet, Consumer<Column> consumer) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        ColumnEditor column = Column.editor();
        for (int position = 1; position <= metadata.getColumnCount(); ++position) {
            String columnLabel = metadata.getColumnLabel(position);
            column.name(columnLabel != null ? columnLabel : metadata.getColumnName(position));
            column.type(metadata.getColumnTypeName(position));
            column.jdbcType(metadata.getColumnType(position));
            column.length(metadata.getPrecision(position));
            column.scale(metadata.getScale(position));
            column.optional(JdbcConnection.isNullable(metadata.isNullable(position)));
            column.autoIncremented(metadata.isAutoIncrement(position));
            column.generated(false);
            consumer.accept(column.create());
        }
    }

    private static boolean isNullable(int jdbcNullable) {
        return jdbcNullable == 1 || jdbcNullable == 2;
    }

    @FunctionalInterface
    public static interface StatementFactory {
        public Statement createStatement(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface CallPreparer {
        public void accept(CallableStatement var1) throws SQLException;
    }

    public static interface StatementPreparer {
        public void accept(PreparedStatement var1) throws SQLException;
    }

    public static interface SingleParameterResultSetConsumer {
        public boolean accept(String var1, ResultSet var2) throws SQLException;
    }

    public static interface ResultSetConsumer {
        public void accept(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface Operations {
        public void apply(Statement var1) throws SQLException;
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ConnectionFactory {
        public Connection connect(JdbcConfiguration var1) throws SQLException;
    }
}

