/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.ThreadSafe;
import io.debezium.document.Document;
import io.debezium.document.JacksonReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

@ThreadSafe
public interface DocumentReader {
    public static DocumentReader defaultReader() {
        return JacksonReader.INSTANCE;
    }

    public Document read(InputStream var1) throws IOException;

    public Document read(Reader var1) throws IOException;

    public Document read(String var1) throws IOException;

    default public Document read(URL jsonUrl) throws IOException {
        return this.read(jsonUrl.openStream());
    }

    default public Document read(File jsonFile) throws IOException {
        return this.read(new BufferedInputStream(new FileInputStream(jsonFile)));
    }

    default public Document read(byte[] rawBytes) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(rawBytes);){
            Document document = DocumentReader.defaultReader().read(stream);
            return document;
        }
    }
}

