/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.data.Bits;
import io.debezium.data.Xml;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.time.Date;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTime;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.NumberConversions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjuster;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class JdbcValueConverters
implements ValueConverterProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ZoneOffset defaultOffset;
    protected final boolean adaptiveTimePrecision;
    protected final DecimalMode decimalMode;
    private final TemporalAdjuster adjuster;
    protected final BigIntUnsignedMode bigIntUnsignedMode;

    public JdbcValueConverters() {
        this(null, true, ZoneOffset.UTC, null, null);
    }

    public JdbcValueConverters(DecimalMode decimalMode, boolean adaptiveTimePrecision, ZoneOffset defaultOffset, TemporalAdjuster adjuster, BigIntUnsignedMode bigIntUnsignedMode) {
        this.defaultOffset = defaultOffset != null ? defaultOffset : ZoneOffset.UTC;
        this.adaptiveTimePrecision = adaptiveTimePrecision;
        this.decimalMode = decimalMode != null ? decimalMode : DecimalMode.PRECISE;
        this.adjuster = adjuster;
        this.bigIntUnsignedMode = bigIntUnsignedMode != null ? bigIntUnsignedMode : BigIntUnsignedMode.PRECISE;
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        switch (column.jdbcType()) {
            case 0: {
                this.logger.warn("Unexpected JDBC type: NULL");
                return null;
            }
            case -7: {
                if (column.length() > 1) {
                    return Bits.builder(column.length());
                }
            }
            case 16: {
                return SchemaBuilder.bool();
            }
            case -2: 
            case 2004: {
                return SchemaBuilder.bytes();
            }
            case -4: 
            case -3: {
                return SchemaBuilder.bytes();
            }
            case -6: {
                return SchemaBuilder.int8();
            }
            case 5: {
                return SchemaBuilder.int16();
            }
            case 4: {
                return SchemaBuilder.int32();
            }
            case -5: {
                return SchemaBuilder.int64();
            }
            case 7: {
                return SchemaBuilder.float32();
            }
            case 6: 
            case 8: {
                return SchemaBuilder.float64();
            }
            case 2: 
            case 3: {
                switch (this.decimalMode) {
                    case DOUBLE: {
                        return SchemaBuilder.float64();
                    }
                    case PRECISE: {
                        return Decimal.builder((int)column.scale());
                    }
                }
            }
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 2011: {
                return SchemaBuilder.string();
            }
            case -1: 
            case 12: 
            case 70: 
            case 2005: {
                return SchemaBuilder.string();
            }
            case 2009: {
                return Xml.builder();
            }
            case 91: {
                if (this.adaptiveTimePrecision) {
                    return Date.builder();
                }
                return org.apache.kafka.connect.data.Date.builder();
            }
            case 92: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3) {
                        return io.debezium.time.Time.builder();
                    }
                    if (column.length() <= 6) {
                        return MicroTime.builder();
                    }
                    return NanoTime.builder();
                }
                return Time.builder();
            }
            case 93: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3 || !this.adaptiveTimePrecision) {
                        return Timestamp.builder();
                    }
                    if (column.length() <= 6) {
                        return MicroTimestamp.builder();
                    }
                    return NanoTimestamp.builder();
                }
                return org.apache.kafka.connect.data.Timestamp.builder();
            }
            case 2013: {
                return ZonedTime.builder();
            }
            case 2014: {
                return ZonedTimestamp.builder();
            }
            case -8: {
                return SchemaBuilder.bytes();
            }
        }
        return null;
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case 0: {
                return data -> null;
            }
            case -7: {
                return this.convertBits(column, fieldDefn);
            }
            case 16: {
                return data -> this.convertBoolean(column, fieldDefn, data);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data);
            }
            case -6: {
                return data -> this.convertTinyInt(column, fieldDefn, data);
            }
            case 5: {
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case 4: {
                return data -> this.convertInteger(column, fieldDefn, data);
            }
            case -5: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 6: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 8: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 7: {
                return data -> this.convertReal(column, fieldDefn, data);
            }
            case 2: {
                switch (this.decimalMode) {
                    case DOUBLE: {
                        return data -> this.convertDouble(column, fieldDefn, data);
                    }
                    case PRECISE: {
                        return data -> this.convertNumeric(column, fieldDefn, data);
                    }
                }
            }
            case 3: {
                switch (this.decimalMode) {
                    case DOUBLE: {
                        return data -> this.convertDouble(column, fieldDefn, data);
                    }
                    case PRECISE: {
                        return data -> this.convertDecimal(column, fieldDefn, data);
                    }
                }
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 91: {
                if (this.adaptiveTimePrecision) {
                    return data -> this.convertDateToEpochDays(column, fieldDefn, data);
                }
                return data -> this.convertDateToEpochDaysAsDate(column, fieldDefn, data);
            }
            case 92: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3) {
                        return data -> this.convertTimeToMillisPastMidnight(column, fieldDefn, data);
                    }
                    if (column.length() <= 6) {
                        return data -> this.convertTimeToMicrosPastMidnight(column, fieldDefn, data);
                    }
                    return data -> this.convertTimeToNanosPastMidnight(column, fieldDefn, data);
                }
                return data -> this.convertTimeToMillisPastMidnightAsDate(column, fieldDefn, data);
            }
            case 93: {
                if (this.adaptiveTimePrecision) {
                    if (column.length() <= 3) {
                        return data -> this.convertTimestampToEpochMillis(column, fieldDefn, data);
                    }
                    if (column.length() <= 6) {
                        return data -> this.convertTimestampToEpochMicros(column, fieldDefn, data);
                    }
                    return data -> this.convertTimestampToEpochNanos(column, fieldDefn, data);
                }
                return data -> this.convertTimestampToEpochMillisAsDate(column, fieldDefn, data);
            }
            case 2013: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 2014: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -8: {
                return data -> this.convertRowId(column, fieldDefn, data);
            }
        }
        return null;
    }

    protected ValueConverter convertBits(Column column, Field fieldDefn) {
        if (column.length() > 1) {
            int numBits = column.length();
            int numBytes = numBits / 8 + (numBits % 8 == 0 ? 0 : 1);
            return data -> this.convertBits(column, fieldDefn, data, numBytes);
        }
        return data -> this.convertBit(column, fieldDefn, data);
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            data = OffsetDateTime.of(LocalDate.ofEpochDay(0L), LocalTime.MIDNIGHT, this.defaultOffset);
        }
        try {
            return ZonedTimestamp.toIsoString(data, (ZoneId)this.defaultOffset, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            data = OffsetTime.of(LocalTime.MIDNIGHT, this.defaultOffset);
        }
        try {
            return ZonedTime.toIsoString(data, (ZoneId)this.defaultOffset, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            return Timestamp.toEpochMillis(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            return MicroTimestamp.toEpochMicros(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            return NanoTimestamp.toEpochNanos(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return new java.util.Date(0L);
        }
        try {
            return new java.util.Date(Timestamp.toEpochMillis(data, this.adjuster));
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToMillisPastMidnight(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0;
        }
        try {
            return io.debezium.time.Time.toMilliOfDay(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToMicrosPastMidnight(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            return MicroTime.toMicroOfDay(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToNanosPastMidnight(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            return NanoTime.toNanoOfDay(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertTimeToMillisPastMidnightAsDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        try {
            return new java.util.Date(io.debezium.time.Time.toMilliOfDay(data, this.adjuster));
        }
        catch (IllegalArgumentException e) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertDateToEpochDays(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0;
        }
        try {
            return Date.toEpochDay(data, this.adjuster);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            return this.handleUnknownData(column, fieldDefn, data);
        }
    }

    protected Object convertDateToEpochDaysAsDate(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return new java.util.Date(0L);
        }
        try {
            int epochDay = Date.toEpochDay(data, this.adjuster);
            long epochMillis = TimeUnit.DAYS.toMillis(epochDay);
            return new java.util.Date(epochMillis);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unexpected JDBC DATE value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), data.getClass(), data});
            return null;
        }
    }

    protected Object convertBinary(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            data = NumberConversions.BYTE_ZERO;
        }
        if (data instanceof char[]) {
            data = new String((char[])data);
        }
        if (data instanceof String) {
            data = ((String)data).getBytes();
        }
        if (data instanceof byte[]) {
            return this.convertByteArray(column, (byte[])data);
        }
        return this.unexpectedBinary(data, fieldDefn);
    }

    protected ByteBuffer convertByteArray(Column column, byte[] data) {
        return ByteBuffer.wrap(data);
    }

    protected byte[] unexpectedBinary(Object value, Field fieldDefn) {
        this.logger.warn("Unexpected JDBC BINARY value for field {} with schema {}: class={}, value={}", new Object[]{fieldDefn.name(), fieldDefn.schema(), value.getClass(), value});
        return null;
    }

    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertSmallInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return NumberConversions.SHORT_FALSE;
        }
        if (data instanceof Short) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Short(value.shortValue());
        }
        if (data instanceof Boolean) {
            return NumberConversions.getShort((Boolean)data);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0;
        }
        if (data instanceof Integer) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Integer(value.intValue());
        }
        if (data instanceof Boolean) {
            return NumberConversions.getInteger((Boolean)data);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBigInt(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        if (data instanceof Long) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Long(value.longValue());
        }
        if (data instanceof Boolean) {
            return NumberConversions.getLong((Boolean)data);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        return this.convertDouble(column, fieldDefn, data);
    }

    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0.0;
        }
        if (data instanceof Double) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Double(value.doubleValue());
        }
        if (data instanceof Boolean) {
            return NumberConversions.getDouble((Boolean)data);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertReal(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return Float.valueOf(0.0f);
        }
        if (data instanceof Float) {
            return data;
        }
        if (data instanceof Number) {
            Number value = (Number)data;
            return new Float(value.floatValue());
        }
        if (data instanceof Boolean) {
            return NumberConversions.getFloat((Boolean)data);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return BigDecimal.ZERO;
        }
        BigDecimal decimal = null;
        if (data instanceof BigDecimal) {
            decimal = (BigDecimal)data;
        } else if (data instanceof Boolean) {
            decimal = NumberConversions.getBigDecimal((Boolean)data);
        } else if (data instanceof Short) {
            decimal = new BigDecimal(((Short)data).intValue());
        } else if (data instanceof Integer) {
            decimal = new BigDecimal((Integer)data);
        } else if (data instanceof Long) {
            decimal = BigDecimal.valueOf((Long)data);
        } else if (data instanceof Float) {
            decimal = BigDecimal.valueOf(((Float)data).doubleValue());
        } else if (data instanceof Double) {
            decimal = BigDecimal.valueOf((Double)data);
        } else {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return decimal;
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return BigDecimal.ZERO;
        }
        BigDecimal decimal = null;
        if (data instanceof BigDecimal) {
            decimal = (BigDecimal)data;
        } else if (data instanceof Boolean) {
            decimal = NumberConversions.getBigDecimal((Boolean)data);
        } else if (data instanceof Short) {
            decimal = new BigDecimal(((Short)data).intValue());
        } else if (data instanceof Integer) {
            decimal = new BigDecimal((Integer)data);
        } else if (data instanceof Long) {
            decimal = BigDecimal.valueOf((Long)data);
        } else if (data instanceof Float) {
            decimal = BigDecimal.valueOf(((Float)data).doubleValue());
        } else if (data instanceof Double) {
            decimal = BigDecimal.valueOf((Double)data);
        } else {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return decimal;
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return "";
        }
        if (data instanceof SQLXML) {
            try {
                return ((SQLXML)data).getString();
            }
            catch (SQLException e) {
                throw new RuntimeException("Error processing data from " + column.jdbcType() + " and column " + column + ": class=" + data.getClass(), e);
            }
        }
        return data.toString();
    }

    protected Object convertRowId(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return ByteBuffer.wrap(new byte[0]);
        }
        if (data instanceof RowId) {
            RowId row = (RowId)data;
            return ByteBuffer.wrap(row.getBytes());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return false;
        }
        if (data instanceof Boolean) {
            return data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Integer) {
            return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof BitSet) {
            BitSet value = (BitSet)data;
            return value.get(0);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertBits(Column column, Field fieldDefn, Object data, int numBytes) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return false;
        }
        if (data instanceof Boolean) {
            Boolean value = (Boolean)data;
            return new byte[]{value != false ? (byte)1 : 0};
        }
        if (data instanceof Short) {
            Short value = (Short)data;
            ByteBuffer buffer = ByteBuffer.allocate(2);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(value);
            return buffer.array();
        }
        if (data instanceof Integer) {
            Integer value = (Integer)data;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(value);
            return buffer.array();
        }
        if (data instanceof Long) {
            Long value = (Long)data;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putLong(value);
            return buffer.array();
        }
        if (data instanceof byte[]) {
            byte[] bytes = (byte[])data;
            if (bytes.length == 1) {
                return bytes;
            }
            if (this.byteOrderOfBitType() == ByteOrder.BIG_ENDIAN) {
                int i = 0;
                for (int j = bytes.length - 1; j > i; ++i, --j) {
                    byte tmp = bytes[j];
                    bytes[j] = bytes[i];
                    bytes[i] = tmp;
                }
            }
            return this.padLittleEndian(numBytes, bytes);
        }
        if (data instanceof BitSet) {
            byte[] bytes = ((BitSet)data).toByteArray();
            return this.padLittleEndian(numBytes, bytes);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected byte[] padLittleEndian(int numBytes, byte[] data) {
        if (data.length < numBytes) {
            byte[] padded = new byte[numBytes];
            System.arraycopy(data, 0, padded, 0, data.length);
            for (int i = data.length; i != numBytes; ++i) {
                padded[i] = 0;
            }
            return padded;
        }
        return data;
    }

    protected ByteOrder byteOrderOfBitType() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return false;
        }
        if (data instanceof Boolean) {
            return data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Integer) {
            return (Integer)data == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object handleUnknownData(Column column, Field fieldDefn, Object data) {
        if (column.isOptional() || fieldDefn.schema().isOptional()) {
            Class<?> dataClass = data.getClass();
            this.logger.warn("Unexpected value for JDBC type {} and column {}: class={}", new Object[]{column.jdbcType(), column, dataClass.isArray() ? dataClass.getSimpleName() : dataClass.getName()});
            return null;
        }
        throw new IllegalArgumentException("Unexpected value for JDBC type " + column.jdbcType() + " and column " + column + ": class=" + data.getClass());
    }

    public static enum BigIntUnsignedMode {
        PRECISE,
        LONG;

    }

    public static enum DecimalMode {
        PRECISE,
        DOUBLE;

    }
}

