/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import io.debezium.function.BlockingConsumer;
import java.util.function.Function;

public interface BufferedBlockingConsumer<T>
extends BlockingConsumer<T> {
    default public void flush() throws InterruptedException {
        this.flush(t -> t);
    }

    public void flush(Function<T, T> var1) throws InterruptedException;

    public static <T> BufferedBlockingConsumer<T> bufferLast(final BlockingConsumer<T> delegate) {
        return new BufferedBlockingConsumer<T>(){
            private T last;

            @Override
            public void accept(T t) throws InterruptedException {
                if (this.last != null) {
                    delegate.accept(this.last);
                }
                this.last = t;
            }

            @Override
            public void flush(Function<T, T> function) throws InterruptedException {
                if (this.last != null) {
                    try {
                        delegate.accept(function.apply(this.last));
                    }
                    finally {
                        this.last = null;
                    }
                }
            }
        };
    }
}

