/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.Immutable;
import java.util.Arrays;

@Immutable
public class HashCode {
    private static final int PRIME = 103;

    public static int compute(Object ... objects) {
        return HashCode.computeHashCode(0, objects);
    }

    private static int computeHashCode(int seed, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return seed * 103;
        }
        int hc = seed;
        for (Object object : objects) {
            hc = 103 * hc;
            if (object instanceof byte[]) {
                hc += Arrays.hashCode((byte[])object);
                continue;
            }
            if (object instanceof boolean[]) {
                hc += Arrays.hashCode((boolean[])object);
                continue;
            }
            if (object instanceof short[]) {
                hc += Arrays.hashCode((short[])object);
                continue;
            }
            if (object instanceof int[]) {
                hc += Arrays.hashCode((int[])object);
                continue;
            }
            if (object instanceof long[]) {
                hc += Arrays.hashCode((long[])object);
                continue;
            }
            if (object instanceof float[]) {
                hc += Arrays.hashCode((float[])object);
                continue;
            }
            if (object instanceof double[]) {
                hc += Arrays.hashCode((double[])object);
                continue;
            }
            if (object instanceof char[]) {
                hc += Arrays.hashCode((char[])object);
                continue;
            }
            if (object instanceof Object[]) {
                hc += Arrays.hashCode((Object[])object);
                continue;
            }
            if (object == null) continue;
            hc += object.hashCode();
        }
        return hc;
    }

    private HashCode() {
    }
}

