/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.ColumnEditorImpl;

@Immutable
public interface Column
extends Comparable<Column> {
    public static ColumnEditor editor() {
        return new ColumnEditorImpl();
    }

    public String name();

    public int position();

    public int jdbcType();

    public String typeName();

    public int length();

    public int scale();

    public boolean isOptional();

    default public boolean isRequired() {
        return !this.isOptional();
    }

    public boolean isAutoIncremented();

    public boolean isGenerated();

    @Override
    default public int compareTo(Column that) {
        if (this == that) {
            return 0;
        }
        return this.position() - that.position();
    }

    default public ColumnEditor edit() {
        return Column.editor().name(this.name()).typeName(this.typeName()).jdbcType(this.jdbcType()).length(this.length()).scale(this.scale()).position(this.position()).optional(this.isOptional()).autoIncremented(this.isAutoIncremented()).generated(this.isGenerated());
    }
}

