/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.annotation.Immutable;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;

@Immutable
public class TimeZoneAdapter {
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    public static final ZoneId UTC = ZoneId.of("UTC");
    private final ZoneId targetZoneId;
    private final ZoneId utilDateZoneId;
    private final ZoneId sqlDateZoneId;
    private final ZoneId sqlTimeZoneId;
    private final ZoneId sqlTimestampZoneId;

    public static TimeZoneAdapter create() {
        return new TimeZoneAdapter(UTC, UTC, UTC, UTC, UTC);
    }

    public static TimeZoneAdapter originatingIn(ZoneId zoneId) {
        return new TimeZoneAdapter(ZoneId.systemDefault(), zoneId, zoneId, zoneId, zoneId);
    }

    public static TimeZoneAdapter originatingInUtc() {
        return TimeZoneAdapter.originatingIn(UTC);
    }

    public static TimeZoneAdapter originatingInLocal() {
        return TimeZoneAdapter.originatingIn(ZoneId.systemDefault());
    }

    protected TimeZoneAdapter(ZoneId targetZoneId, ZoneId utilDateZoneId, ZoneId sqlDateZoneId, ZoneId sqlTimeZoneId, ZoneId sqlTimestampZoneId) {
        this.targetZoneId = targetZoneId;
        this.utilDateZoneId = utilDateZoneId;
        this.sqlDateZoneId = sqlDateZoneId;
        this.sqlTimeZoneId = sqlTimeZoneId;
        this.sqlTimestampZoneId = sqlTimestampZoneId;
    }

    protected ZoneId targetZoneId() {
        return this.targetZoneId;
    }

    public ZonedDateTime toZonedDateTime(Date dbDate) {
        if (dbDate instanceof java.sql.Date) {
            return this.toZonedDateTime((java.sql.Date)dbDate);
        }
        if (dbDate instanceof Time) {
            return this.toZonedDateTime((Time)dbDate);
        }
        if (dbDate instanceof Timestamp) {
            return this.toZonedDateTime((Timestamp)dbDate);
        }
        return dbDate.toInstant().atZone(UTC).withZoneSameInstant(this.sqlTimeZoneId).withZoneSameLocal(this.targetZoneId);
    }

    public ZonedDateTime toZonedDateTime(java.sql.Date dbDate) {
        long millis = dbDate.getTime();
        Instant instant = Instant.ofEpochMilli(millis).truncatedTo(ChronoUnit.DAYS);
        return instant.atZone(this.sqlDateZoneId).withZoneSameInstant(this.targetZoneId);
    }

    public ZonedDateTime toZonedDateTime(Time dbTime) {
        long millis = dbTime.getTime();
        LocalTime local = LocalTime.ofNanoOfDay(millis * 1000L * 1000L);
        return ZonedDateTime.of(EPOCH, local, UTC).withZoneSameInstant(this.sqlTimeZoneId).withZoneSameLocal(this.targetZoneId);
    }

    public ZonedDateTime toZonedDateTime(Timestamp dbTimestamp) {
        return dbTimestamp.toInstant().atZone(UTC).withZoneSameInstant(this.sqlTimestampZoneId).withZoneSameLocal(this.targetZoneId);
    }

    public TimeZoneAdapter withTargetZone(ZoneId zoneId) {
        if (this.targetZoneId.equals(zoneId)) {
            return this;
        }
        return new TimeZoneAdapter(zoneId, this.utilDateZoneId, this.sqlDateZoneId, this.sqlTimeZoneId, this.sqlTimestampZoneId);
    }

    public TimeZoneAdapter withZoneForAll(ZoneId zoneId) {
        return new TimeZoneAdapter(this.targetZoneId, zoneId, zoneId, zoneId, zoneId);
    }

    public TimeZoneAdapter withZoneForUtilDate(ZoneId zoneId) {
        if (this.utilDateZoneId.equals(zoneId)) {
            return this;
        }
        return new TimeZoneAdapter(this.targetZoneId, zoneId, this.sqlDateZoneId, this.sqlTimeZoneId, this.sqlTimestampZoneId);
    }

    public TimeZoneAdapter withZoneForSqlDate(ZoneId zoneId) {
        if (this.sqlDateZoneId.equals(zoneId)) {
            return this;
        }
        return new TimeZoneAdapter(this.targetZoneId, this.utilDateZoneId, zoneId, this.sqlTimeZoneId, this.sqlTimestampZoneId);
    }

    public TimeZoneAdapter withZoneForSqlTime(ZoneId zoneId) {
        if (this.sqlTimeZoneId.equals(zoneId)) {
            return this;
        }
        return new TimeZoneAdapter(this.targetZoneId, this.utilDateZoneId, this.sqlDateZoneId, zoneId, this.sqlTimestampZoneId);
    }

    public TimeZoneAdapter withZoneForSqlTimestamp(ZoneId zoneId) {
        if (this.sqlTimestampZoneId.equals(zoneId)) {
            return this;
        }
        return new TimeZoneAdapter(this.targetZoneId, this.utilDateZoneId, this.sqlDateZoneId, this.sqlTimeZoneId, zoneId);
    }

    public TimeZoneAdapter withUtcTargetZone() {
        return this.withTargetZone(UTC);
    }

    public TimeZoneAdapter withUtcZoneForUtilDate() {
        return this.withZoneForUtilDate(UTC);
    }

    public TimeZoneAdapter withUtcZoneForSqlDate() {
        return this.withZoneForSqlDate(UTC);
    }

    public TimeZoneAdapter withUtcZoneForSqlTime() {
        return this.withZoneForSqlTime(UTC);
    }

    public TimeZoneAdapter withUtcZoneForSqlTimestamp() {
        return this.withZoneForSqlTimestamp(UTC);
    }

    public TimeZoneAdapter withLocalTargetZone() {
        return this.withTargetZone(ZoneId.systemDefault());
    }

    public TimeZoneAdapter withLocalZoneForUtilDate() {
        return this.withZoneForUtilDate(ZoneId.systemDefault());
    }

    public TimeZoneAdapter withLocalZoneForSqlDate() {
        return this.withZoneForSqlDate(ZoneId.systemDefault());
    }

    public TimeZoneAdapter withLocalZoneForSqlTime() {
        return this.withZoneForSqlTime(ZoneId.systemDefault());
    }

    public TimeZoneAdapter withLocalZoneForSqlTimestamp() {
        return this.withZoneForSqlTimestamp(ZoneId.systemDefault());
    }
}

