/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class SchemaUtil {
    private SchemaUtil() {
    }

    public static String asString(Object field) {
        return new RecordWriter().append(field).toString();
    }

    public static String asString(Field field) {
        return new RecordWriter().append(field).toString();
    }

    public static String asString(Struct struct) {
        return new RecordWriter().append(struct).toString();
    }

    public static String asString(Schema schema) {
        return new RecordWriter().append(schema).toString();
    }

    public static String asString(SourceRecord record) {
        return new RecordWriter().append(record).toString();
    }

    public static String asDetailedString(Field field) {
        return new RecordWriter().append(field).toString();
    }

    public static String asDetailedString(Struct struct) {
        return new RecordWriter().append(struct).toString();
    }

    public static String asDetailedString(Schema schema) {
        return new RecordWriter().append(schema).toString();
    }

    public static String asDetailedString(SourceRecord record) {
        return new RecordWriter().append(record).toString();
    }

    protected static class RecordWriter {
        private final StringBuilder sb = new StringBuilder();
        private boolean detailed = false;

        protected RecordWriter() {
        }

        public RecordWriter detailed(boolean detailed) {
            this.detailed = detailed;
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public RecordWriter append(Object obj) {
            if (obj == null) {
                this.sb.append("null");
            } else if (obj instanceof Schema) {
                Schema schema = (Schema)obj;
                this.sb.append('{');
                if (schema.name() != null) {
                    this.appendFirst("name", schema.name());
                    this.appendAdditional("type", schema.type());
                } else {
                    this.appendFirst("type", schema.type());
                }
                this.appendAdditional("optional", schema.isOptional());
                if (schema.doc() != null) {
                    this.appendAdditional("doc", schema.doc());
                }
                if (schema.version() != null) {
                    this.appendAdditional("version", schema.version());
                }
                switch (schema.type()) {
                    case STRUCT: {
                        this.appendAdditional("fields", schema.fields());
                        break;
                    }
                    case MAP: {
                        this.appendAdditional("key", schema.keySchema());
                        this.appendAdditional("value", schema.valueSchema());
                        break;
                    }
                    case ARRAY: {
                        this.appendAdditional("value", schema.valueSchema());
                        break;
                    }
                }
                this.sb.append('}');
            } else if (obj instanceof Struct) {
                Struct s = (Struct)obj;
                this.sb.append('{');
                boolean first = true;
                for (Field field : s.schema().fields()) {
                    if (first) {
                        first = false;
                    } else {
                        this.sb.append(", ");
                    }
                    this.appendFirst(field.name(), s.get(field));
                }
                this.sb.append('}');
            } else if (obj instanceof ByteBuffer) {
                ByteBuffer b = (ByteBuffer)obj;
                this.sb.append('\"').append(Base64.getEncoder().encode(b.array())).append('\"');
            } else if (obj instanceof byte[]) {
                this.sb.append('\"').append(Base64.getEncoder().encode((byte[])obj)).append('\"');
            } else if (obj instanceof Map) {
                Map map = (Map)obj;
                this.sb.append('{');
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        this.appendFirst(entry.getKey().toString(), entry.getValue());
                        first = false;
                        continue;
                    }
                    this.appendAdditional(entry.getKey().toString(), entry.getValue());
                }
                this.sb.append('}');
            } else if (obj instanceof List) {
                List list = (List)obj;
                this.sb.append('[');
                boolean first = true;
                for (Object value : list) {
                    if (first) {
                        first = false;
                    } else {
                        this.sb.append(", ");
                    }
                    this.append(value);
                }
                this.sb.append(']');
            } else if (obj instanceof Field) {
                Field f = (Field)obj;
                this.sb.append('{');
                this.appendFirst("name", f.name());
                this.appendAdditional("index", f.index());
                this.appendAdditional("schema", f.schema());
                this.sb.append('}');
            } else if (obj instanceof String) {
                this.sb.append('\"').append(obj.toString()).append('\"');
            } else if (obj instanceof Schema.Type) {
                this.sb.append('\"').append(obj.toString()).append('\"');
            } else if (obj instanceof SourceRecord) {
                SourceRecord record = (SourceRecord)obj;
                this.sb.append('{');
                this.appendFirst("sourcePartition", record.sourcePartition());
                this.appendAdditional("sourceOffset", record.sourceOffset());
                this.appendAdditional("topic", record.topic());
                this.appendAdditional("kafkaPartition", record.kafkaPartition());
                if (this.detailed) {
                    this.appendAdditional("keySchema", record.keySchema());
                }
                this.appendAdditional("key", record.key());
                if (this.detailed) {
                    this.appendAdditional("valueSchema", record.valueSchema());
                }
                this.appendAdditional("value", record.value());
                this.sb.append('}');
            } else {
                this.sb.append(obj.toString());
            }
            return this;
        }

        protected void appendFirst(String name, Object value) {
            this.append(name);
            this.sb.append(" : ");
            this.append(value);
        }

        protected void appendAdditional(String name, Object value) {
            this.sb.append(", ");
            this.append(name);
            this.sb.append(" : ");
            this.append(value);
        }
    }
}

