/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerConnectorTask;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnector.class);
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public Class<? extends Task> taskClass() {
        return SqlServerConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        List<Map<String, String>> list;
        block9: {
            if (maxTasks > 1 && !this.properties.containsKey(SqlServerConnectorConfig.DATABASE_NAMES.name())) {
                throw new IllegalArgumentException("Only a single connector task may be started in single-partition mode");
            }
            SqlServerConnectorConfig config = new SqlServerConnectorConfig(Configuration.from(this.properties));
            SqlServerConnection connection = this.connect(config);
            try {
                list = this.buildTaskConfigs(connection, config, maxTasks);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalArgumentException("Could not build task configs", e);
                }
            }
            connection.close();
        }
        return list;
    }

    private List<Map<String, String>> buildTaskConfigs(SqlServerConnection connection, SqlServerConnectorConfig config, int maxTasks) {
        int taskIndex;
        List<String> databaseNames = config.getDatabaseNames();
        ArrayList databasesByTask = new ArrayList();
        for (int i = 0; i < maxTasks; ++i) {
            databasesByTask.add(new ArrayList());
        }
        for (int databaseNameIndex = 0; databaseNameIndex < databaseNames.size(); ++databaseNameIndex) {
            taskIndex = databaseNameIndex % maxTasks;
            String realDatabaseName = connection.retrieveRealDatabaseName(databaseNames.get(databaseNameIndex));
            ((List)databasesByTask.get(taskIndex)).add(realDatabaseName);
        }
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        for (taskIndex = 0; taskIndex < maxTasks; ++taskIndex) {
            String taskDatabases = String.join((CharSequence)",", (Iterable)databasesByTask.get(taskIndex));
            HashMap<String, String> taskProperties = new HashMap<String, String>(this.properties);
            taskProperties.put(SqlServerConnectorConfig.DATABASE_NAMES.name(), taskDatabases);
            taskProperties.put("task.id", String.valueOf(taskIndex));
            taskConfigs.add(Collections.unmodifiableMap(taskProperties));
        }
        return taskConfigs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return SqlServerConnectorConfig.configDef();
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        if (!configValues.get(SqlServerConnectorConfig.DATABASE_NAMES.name()).errorMessages().isEmpty()) {
            return;
        }
        SqlServerConnectorConfig sqlServerConfig = new SqlServerConnectorConfig(config);
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConfigValue userValue = configValues.get(RelationalDatabaseConnectorConfig.USER.name());
        try (SqlServerConnection connection = this.connect(sqlServerConfig);){
            connection.execute(new String[]{"SELECT @@VERSION"});
            LOGGER.debug("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
            LOGGER.info("Checking if user has access to CDC table");
            if (sqlServerConfig.getSnapshotMode() != SqlServerConnectorConfig.SnapshotMode.INITIAL_ONLY) {
                ArrayList<String> noAccessDatabaseNames = new ArrayList<String>();
                for (String databaseName : sqlServerConfig.getDatabaseNames()) {
                    if (connection.checkIfConnectedUserHasAccessToCDCTable(databaseName)) continue;
                    noAccessDatabaseNames.add(databaseName);
                }
                if (!noAccessDatabaseNames.isEmpty()) {
                    String errorMessage = String.format("User %s does not have access to CDC schema in the following databases: %s. This user can only be used in initial_only snapshot mode", config.getString(RelationalDatabaseConnectorConfig.USER), String.join((CharSequence)", ", noAccessDatabaseNames));
                    LOGGER.error(errorMessage);
                    userValue.addErrorMessage(errorMessage);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{config.withMaskedPasswords(), userValue, e});
            hostnameValue.addErrorMessage("Unable to connect. Check this and other connection properties. Error: " + e.getMessage());
        }
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(SqlServerConnectorConfig.ALL_FIELDS);
    }

    private SqlServerConnection connect(SqlServerConnectorConfig sqlServerConfig) {
        return new SqlServerConnection(sqlServerConfig.getJdbcConfig(), null, Collections.emptySet(), sqlServerConfig.useSingleDatabase());
    }
}

