/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.common.Partition;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SqlServerPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public SqlServerPartition(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlServerPartition other = (SqlServerPartition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    static class Provider
    implements Partition.Provider<SqlServerPartition> {
        private final SqlServerConnectorConfig connectorConfig;

        Provider(SqlServerConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<SqlServerPartition> getPartitions() {
            return Collections.singleton(new SqlServerPartition(this.connectorConfig.getLogicalName()));
        }
    }
}

