/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.TxLogPosition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.spi.ChangeTableResultSet;
import io.debezium.relational.ChangeTable;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.util.ColumnUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlServerChangeTablePointer
extends ChangeTableResultSet<SqlServerChangeTable, TxLogPosition> {
    private static final int COL_COMMIT_LSN = 1;
    private static final int COL_ROW_LSN = 2;
    private static final int COL_OPERATION = 3;
    private static final int COL_DATA = 5;
    private JdbcConnection.ResultSetMapper<Object[]> resultSetMapper;
    private final ResultSet resultSet;
    private final int columnDataOffset;

    public SqlServerChangeTablePointer(SqlServerChangeTable changeTable, ResultSet resultSet) {
        this(changeTable, resultSet, 5);
    }

    public SqlServerChangeTablePointer(SqlServerChangeTable changeTable, ResultSet resultSet, int columnDataOffset) {
        super((ChangeTable)changeTable, resultSet, columnDataOffset);
        this.resultSet = resultSet;
        this.columnDataOffset = columnDataOffset;
    }

    protected int getOperation(ResultSet resultSet) throws SQLException {
        return resultSet.getInt(3);
    }

    protected Object getColumnData(ResultSet resultSet, int columnIndex) throws SQLException {
        if (resultSet.getMetaData().getColumnType(columnIndex) == 92) {
            return resultSet.getTime(columnIndex);
        }
        return super.getColumnData(resultSet, columnIndex);
    }

    protected TxLogPosition getNextChangePosition(ResultSet resultSet) throws SQLException {
        return this.isCompleted() ? TxLogPosition.NULL : TxLogPosition.valueOf(Lsn.valueOf(resultSet.getBytes(1)), Lsn.valueOf(resultSet.getBytes(2)));
    }

    protected boolean isNewTransaction() throws SQLException {
        return this.getPreviousChangePosition() != null && ((TxLogPosition)this.getChangePosition()).getCommitLsn().compareTo(((TxLogPosition)this.getPreviousChangePosition()).getCommitLsn()) > 0;
    }

    public Object[] getData() throws SQLException {
        if (this.resultSetMapper == null) {
            this.resultSetMapper = this.createResultSetMapper(((SqlServerChangeTable)this.getChangeTable()).getSourceTable());
        }
        return (Object[])this.resultSetMapper.apply(this.resultSet);
    }

    private JdbcConnection.ResultSetMapper<Object[]> createResultSetMapper(Table table) throws SQLException {
        ColumnUtils.MappedColumns columnMap = ColumnUtils.toMap((Table)table);
        List<String> resultColumns = this.getResultColumnNames();
        int resultColumnCount = resultColumns.size();
        IndicesMapping indicesMapping = new IndicesMapping(columnMap.getSourceTableColumns(), resultColumns);
        return resultSet -> {
            Object[] data = new Object[columnMap.getGreatestColumnPosition()];
            for (int i = 0; i < resultColumnCount; ++i) {
                int index = indicesMapping.getSourceTableColumnIndex(i);
                data[index] = this.getColumnData(resultSet, this.columnDataOffset + i);
            }
            return data;
        };
    }

    private List<String> getResultColumnNames() throws SQLException {
        int columnCount = this.resultSet.getMetaData().getColumnCount() - (this.columnDataOffset - 1);
        ArrayList<String> columns = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columns.add(this.resultSet.getMetaData().getColumnName(this.columnDataOffset + i));
        }
        return columns;
    }

    private class IndicesMapping {
        private final Map<Integer, Integer> mapping;

        IndicesMapping(Map<String, Column> sourceTableColumns, List<String> captureInstanceColumns) {
            this.mapping = new HashMap<Integer, Integer>(sourceTableColumns.size(), 1.0f);
            for (int i = 0; i < captureInstanceColumns.size(); ++i) {
                this.mapping.put(i, sourceTableColumns.get(captureInstanceColumns.get(i)).position() - 1);
            }
        }

        int getSourceTableColumnIndex(int resultCaptureInstanceColumnIndex) {
            return this.mapping.get(resultCaptureInstanceColumnIndex);
        }
    }
}

