/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SnapshotChangeRecordEmitter;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.TxLogPosition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.HistorizedRelationalSnapshotChangeEventSource;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerSnapshotChangeEventSource
extends HistorizedRelationalSnapshotChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerSnapshotChangeEventSource.class);
    private static final int TRANSACTION_SNAPSHOT = 4096;
    private final SqlServerConnectorConfig connectorConfig;
    private final SqlServerConnection jdbcConnection;

    public SqlServerSnapshotChangeEventSource(SqlServerConnectorConfig connectorConfig, SqlServerOffsetContext previousOffset, SqlServerConnection jdbcConnection, SqlServerDatabaseSchema schema, EventDispatcher<TableId> dispatcher, Clock clock, SnapshotProgressListener snapshotProgressListener) {
        super((RelationalDatabaseConnectorConfig)connectorConfig, (OffsetContext)previousOffset, (JdbcConnection)jdbcConnection, (HistorizedRelationalDatabaseSchema)schema, dispatcher, clock, snapshotProgressListener);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
    }

    protected HistorizedRelationalSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(OffsetContext previousOffset) {
        boolean snapshotSchema = true;
        boolean snapshotData = true;
        if (previousOffset != null && !previousOffset.isSnapshotRunning()) {
            LOGGER.info("A previous offset indicating a completed snapshot has been found. Neither schema nor data will be snapshotted.");
            snapshotSchema = false;
            snapshotData = false;
        } else {
            LOGGER.info("No previous offset has been found");
            if (this.connectorConfig.getSnapshotMode().includeData()) {
                LOGGER.info("According to the connector configuration both schema and data will be snapshotted");
            } else {
                LOGGER.info("According to the connector configuration only schema will be snapshotted");
            }
            snapshotData = this.connectorConfig.getSnapshotMode().includeData();
        }
        return new HistorizedRelationalSnapshotChangeEventSource.SnapshottingTask(snapshotSchema, snapshotData);
    }

    protected HistorizedRelationalSnapshotChangeEventSource.SnapshotContext prepare(ChangeEventSource.ChangeEventSourceContext context) throws Exception {
        return new SqlServerSnapshotContext(this.jdbcConnection.getRealDatabaseName());
    }

    protected void connectionCreated(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext) throws Exception {
        ((SqlServerSnapshotContext)snapshotContext).isolationLevelBeforeStart = this.jdbcConnection.connection().getTransactionIsolation();
        if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT) {
            this.jdbcConnection.connection().rollback();
            this.jdbcConnection.connection().setTransactionIsolation(4096);
        }
    }

    protected Set<TableId> getAllTableIds(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext ctx) throws Exception {
        return this.jdbcConnection.readTableNames(ctx.catalogName, null, null, new String[]{"TABLE"});
    }

    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(1);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT) {
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.EXCLUSIVE || this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().setTransactionIsolation(4);
            ((SqlServerSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("dbz_schema_snapshot");
            LOGGER.info("Executing schema locking");
            try (Statement statement = this.jdbcConnection.connection().createStatement(1003, 1007);){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    LOGGER.info("Locking table {}", (Object)tableId);
                    String query = String.format("SELECT * FROM [%s] WITH (TABLOCKX)", tableId.table());
                    statement.executeQuery(query).close();
                }
            }
        } else {
            throw new IllegalStateException("Unknown locking mode specified.");
        }
    }

    protected void releaseSchemaSnapshotLocks(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().rollback(((SqlServerSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
            LOGGER.info("Schema locks released.");
        }
    }

    protected void determineSnapshotOffset(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext ctx) throws Exception {
        ctx.offset = new SqlServerOffsetContext(this.connectorConfig.getLogicalName(), TxLogPosition.valueOf(this.jdbcConnection.getMaxLsn()), false, false);
    }

    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext) throws SQLException, InterruptedException {
        Set schemas = snapshotContext.capturedTables.stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            LOGGER.info("Reading structure of schema '{}'", (Object)snapshotContext.catalogName);
            this.jdbcConnection.readSchema(snapshotContext.tables, snapshotContext.catalogName, schema, this.connectorConfig.getTableFilters().dataCollectionFilter(), null, false);
        }
    }

    protected SchemaChangeEvent getCreateTableEvent(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext, Table table) throws SQLException {
        return new SchemaChangeEvent(snapshotContext.offset.getPartition(), snapshotContext.offset.getOffset(), snapshotContext.catalogName, table.id().schema(), null, table, SchemaChangeEvent.SchemaChangeEventType.CREATE, true);
    }

    protected void complete(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext) {
        try {
            this.jdbcConnection.connection().setTransactionIsolation(((SqlServerSnapshotContext)snapshotContext).isolationLevelBeforeStart);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set transaction isolation level.", e);
        }
    }

    protected String getSnapshotSelect(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext, TableId tableId) {
        return String.format("SELECT * FROM [%s].[%s]", tableId.schema(), tableId.table());
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(HistorizedRelationalSnapshotChangeEventSource.SnapshotContext snapshotContext, Object[] row) {
        ((SqlServerOffsetContext)snapshotContext.offset).setSourceTime(Instant.ofEpochMilli(this.getClock().currentTimeInMillis()));
        return new SnapshotChangeRecordEmitter(snapshotContext.offset, row, this.getClock());
    }

    private static class SqlServerSnapshotContext
    extends HistorizedRelationalSnapshotChangeEventSource.SnapshotContext {
        private int isolationLevelBeforeStart;
        private Savepoint preSchemaSnapshotSavepoint;

        public SqlServerSnapshotContext(String catalogName) throws SQLException {
            super(catalogName);
        }
    }
}

